/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.app.mainplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontrol.swing.dynobject.DynObjectEditor;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.topology.app.mainplugin.DataSetsTreeModel;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.swing.api.TopologySwingServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTopologyServices
implements TopologySwingServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppTopologyServices.class);
    private final Map<TopologySwingServices.WorkingAreaChangedListener, WorkingAreaViewPortListener> workingAreaListener = new HashMap<TopologySwingServices.WorkingAreaChangedListener, WorkingAreaViewPortListener>();
    private ISymbol errorPolygonSymbol = null;
    private ISymbol errorPointSymbol = null;
    private ISymbol errorLineSymbol = null;
    private EditingNotificationObserver editingNotificationObserver = null;

    public TreeModel getDataSetTreeModel() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        return new DataSetsTreeModel(this, view);
    }

    public ListModel getTablesListModel() {
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        TopologyManager manager = TopologyLocator.getTopologyManager();
        DefaultListModel<TopologyDataSet> model = new DefaultListModel<TopologyDataSet>();
        List docs = project.getDocuments(TableManager.TYPENAME);
        for (Document doc : docs) {
            TableDocument table = (TableDocument)doc;
            TopologyDataSet dataset = manager.createDataSet(table.getName(), (DataStore)table.getFeatureStore());
            model.addElement(dataset);
        }
        return model;
    }

    public FeatureStore getFeatureStore(TopologyDataSet dataSet) {
        MutableObject store = new MutableObject();
        store.setValue(null);
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        ArrayList<Document> views = new ArrayList<Document>();
        views.add(project.getActiveDocument(ViewManager.TYPENAME));
        for (Document view : views) {
            if (view == null) continue;
            FLayers layers = ((ViewDocument)view).getMapContext().getLayers();
            try {
                layers.accept(arg_0 -> AppTopologyServices.lambda$getFeatureStore$0(dataSet, (Mutable)store, arg_0));
            }
            catch (VisitCanceledException ex) {
                break;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (store.getValue() == null) {
            for (Document document : project.getDocuments(TableManager.TYPENAME)) {
                TableDocument table = (TableDocument)document;
                if (!dataSet.isThisStore(table.getFeatureStore())) continue;
                store.setValue((Object)table.getFeatureStore());
                break;
            }
        }
        return (FeatureStore)store.getValue();
    }

    public void zoomTo(Envelope envelope) {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        ViewPort viewPort = viewdoc.getMapContext().getViewPort();
        viewPort.setEnvelope(envelope);
    }

    public void refreshView() {
        try {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc == null) {
                return;
            }
            viewdoc.getMapContext().invalidate();
        }
        catch (Exception ex) {
            LOGGER.warn("Cant refresh view", (Throwable)ex);
        }
    }

    public void centerTo(Point point) {
        try {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc == null) {
                return;
            }
            ViewPort viewPort = viewdoc.getMapContext().getViewPort();
            Envelope envelope = (Envelope)viewPort.getEnvelope().clone();
            envelope.centerTo(point);
            viewPort.setEnvelope(envelope);
        }
        catch (Exception ex) {
            LOGGER.warn("Cant center view", (Throwable)ex);
        }
    }

    public Envelope getWorkingArea() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return null;
        }
        ViewPort viewPort = viewdoc.getMapContext().getViewPort();
        return viewPort.getEnvelope();
    }

    public void addWorkingAreaChangedListener(TopologySwingServices.WorkingAreaChangedListener listener) {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        ViewPort viewPort = viewdoc.getMapContext().getViewPort();
        WorkingAreaViewPortListener viewPortListener = this.workingAreaListener.get(listener);
        if (viewPortListener == null) {
            viewPortListener = new WorkingAreaViewPortListener(viewPort, listener);
            this.workingAreaListener.put(listener, viewPortListener);
        } else if (viewPort != viewPortListener.getViewPort()) {
            viewPortListener.getViewPort().removeViewPortListener((ViewPortListener)viewPortListener);
            viewPortListener = new WorkingAreaViewPortListener(viewPort, listener);
            this.workingAreaListener.put(listener, viewPortListener);
        }
        viewPortListener.getViewPort().addViewPortListener((ViewPortListener)viewPortListener);
    }

    public void removeWorkingAreaChangedListener(TopologySwingServices.WorkingAreaChangedListener listener) {
        WorkingAreaViewPortListener viewPortListener = this.workingAreaListener.get(listener);
        if (viewPortListener == null) {
            return;
        }
        viewPortListener.getViewPort().removeViewPortListener((ViewPortListener)viewPortListener);
    }

    public void addError(Geometry geom) {
        ApplicationManager application;
        ViewDocument viewdoc;
        if (this.errorPointSymbol == null) {
            try {
                ISymbol[] symbols;
                File pluginfolder = PluginsLocator.getManager().getPlugin((Object)this).getPluginDirectory();
                File folder = new File(pluginfolder, "symbols");
                block12: for (ISymbol symbol : symbols = MapContextLocator.getSymbolManager().loadSymbols(folder)) {
                    String symbolid;
                    if (!(symbol instanceof ISymbol_v2)) continue;
                    switch (symbolid = ((ISymbol_v2)symbol).getID()) {
                        case "topology-error-polygon": {
                            this.errorPolygonSymbol = symbol;
                            continue block12;
                        }
                        case "topology-error-line": {
                            this.errorLineSymbol = symbol;
                            continue block12;
                        }
                        case "topology-error-point": {
                            this.errorPointSymbol = symbol;
                        }
                    }
                }
            }
            catch (Exception pluginfolder) {
                // empty catch block
            }
        }
        if ((viewdoc = (ViewDocument)(application = ApplicationLocator.getManager()).getActiveDocument(ViewManager.TYPENAME)) != null) {
            MapContext mapContext = viewdoc.getMapContext();
            GraphicLayer gl = mapContext.getGraphicsLayer();
            gl.removeGraphics("topology-errors");
            if (geom != null) {
                ISymbol symbol = null;
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    symbol = this.errorPointSymbol;
                } else if (geom instanceof Curve || geom instanceof MultiCurve) {
                    symbol = this.errorLineSymbol;
                } else if (geom instanceof Surface || geom instanceof MultiSurface) {
                    symbol = this.errorPolygonSymbol;
                }
                if (symbol != null) {
                    int symbolid = gl.getSymbolId(symbol);
                    if (symbolid < 0) {
                        gl.addSymbol(symbol);
                        symbolid = gl.getSymbolId(symbol);
                    }
                    gl.addGraphic("topology-errors", geom, symbolid);
                }
            }
            mapContext.invalidate();
        }
    }

    public void setShowFormWhenEdit(boolean showFormWhenEdit) {
        if (this.editingNotificationObserver == null) {
            this.editingNotificationObserver = new EditingNotificationObserver();
        }
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        if (showFormWhenEdit) {
            editingNotificationManager.addObserver((Observer)this.editingNotificationObserver);
        } else {
            editingNotificationManager.deleteObserver((Observer)this.editingNotificationObserver);
        }
    }

    public ImageIcon getTreeIcon(TreeModel model, Object item) {
        return ((DataSetsTreeModel)model).getTreeIcon(item);
    }

    public void selectFeature(FeatureStore store, FeatureReference ref) {
        try {
            FeatureStore targetTableStore;
            FeatureStore targetLayerStore = this.getStoreOfActiveView(store);
            if (targetLayerStore != null) {
                FeatureSelection targetSelection = targetLayerStore.getFeatureSelection();
                targetSelection.deselectAll();
                FeatureReference targetReference = targetLayerStore.getFeatureReference(ref.getCode());
                targetSelection.select(targetReference);
            }
            if ((targetTableStore = this.getStoreOfActiveTable(store)) != null && targetTableStore != targetLayerStore) {
                FeatureSelection targetSelection = targetTableStore.getFeatureSelection();
                targetSelection.deselectAll();
                FeatureReference targetReference = targetTableStore.getFeatureReference(ref.getCode());
                targetSelection.select(targetReference);
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't select feature.", (Throwable)ex);
        }
    }

    private FeatureStore getStoreOfActiveView(FeatureStore store) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return null;
        }
        Iterator it = view.getMapControl().getMapContext().deepiterator();
        while (it.hasNext()) {
            FLayer layer = (FLayer)it.next();
            if (!(layer instanceof FLyrVect)) continue;
            try {
                FeatureStore x = ((FLyrVect)layer).getFeatureStore();
                if (x == null || !StringUtils.equals((String)x.getFullName(), (String)store.getFullName())) continue;
                return x;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't check if the layer can be valid", (Throwable)ex);
            }
        }
        return null;
    }

    private FeatureStore getStoreOfActiveTable(FeatureStore store) {
        ApplicationManager application = ApplicationLocator.getManager();
        FeatureTableDocumentPanel table = (FeatureTableDocumentPanel)application.getActiveComponent(TableDocument.class);
        if (table == null) {
            return null;
        }
        try {
            FeatureStore x = table.getFeatureStore();
            if (x != null && StringUtils.equals((String)x.getFullName(), (String)store.getFullName())) {
                return x;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check if the layer can be valid", (Throwable)ex);
        }
        return null;
    }

    private List<FLyrVect> getLayers(IView view, Predicate<FLyrVect> valid) {
        FLayer[] actives;
        if (view == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FLyrVect> layers = new ArrayList<FLyrVect>();
        ViewDocument viewDocument = view.getViewDocument();
        for (FLayer layer : actives = viewDocument.getMapContext().getLayers().getActives()) {
            if (!(layer instanceof FLyrVect) || !valid.test((FLyrVect)layer)) continue;
            layers.add((FLyrVect)layer);
        }
        return layers;
    }

    private static /* synthetic */ void lambda$getFeatureStore$0(TopologyDataSet dataSet, Mutable store, Object o) throws VisitCanceledException, BaseException {
        FLyrVect layer;
        if (o instanceof FLyrVect && dataSet.isThisStore((layer = (FLyrVect)o).getFeatureStore())) {
            store.setValue((Object)layer.getFeatureStore());
            throw new VisitCanceledException();
        }
    }

    private class EditingNotificationObserver
    implements Observer {
        public void update(Observable o, Object notification) {
            EditingNotification n = (EditingNotification)notification;
            if (n.isCancelable() && n.getFeature() != null) {
                try {
                    DynObject data = n.getFeature().getAsDynObject();
                    DynObjectEditor editor = new DynObjectEditor(data);
                    editor.setTitle("Topology - " + n.getFeature().getType().getName());
                    editor.editObject(true);
                    if (editor.isCanceled()) {
                        n.cancel();
                    } else {
                        editor.getData(data);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Problems showing the feature in a form.", (Throwable)ex);
                }
            }
        }
    }

    private class WorkingAreaViewPortListener
    implements ViewPortListener {
        private final TopologySwingServices.WorkingAreaChangedListener workingAreaChangedListener;
        private final ViewPort viewPort;

        public WorkingAreaViewPortListener(ViewPort viewPort, TopologySwingServices.WorkingAreaChangedListener workingAreaChangedListener) {
            this.workingAreaChangedListener = workingAreaChangedListener;
            this.viewPort = viewPort;
        }

        public ViewPort getViewPort() {
            return this.viewPort;
        }

        public void extentChanged(ExtentEvent e) {
            this.workingAreaChangedListener.workingAreaChanged(e.getNewExtent());
        }

        public void backColorChanged(ColorEvent e) {
        }

        public void projectionChanged(ProjectionEvent e) {
        }
    }
}

