/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.app.mainplugin;

import javax.swing.ImageIcon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontrol.CompoundLayersTreeModel;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.swing.api.TopologySwingServices;

public class DataSetsTreeModel
implements TreeModel {
    private final ViewDocument view;
    private final CompoundLayersTreeModel deletaged;
    private final TopologySwingServices services;
    private final ListElement<Object> root;

    public DataSetsTreeModel(TopologySwingServices services, ViewDocument view) {
        this.services = services;
        CompoundLayersTreeModel model = (CompoundLayersTreeModel)MapControlLocator.getMapControlManager().createCompoundLayersTreeModel();
        this.view = view;
        if (view != null) {
            model.addLayers(view.getMapContext().getLayers());
        }
        this.deletaged = model;
        this.root = new ListElement("Project", this.deletaged.getRoot());
    }

    private Object getNode(Object value) {
        if (value instanceof ListElement) {
            return ((ListElement)value).getValue();
        }
        return value;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object x = this.deletaged.getChild(parent = this.getNode(parent), index);
        if (x instanceof SingleLayer) {
            SingleLayer layer = (SingleLayer)x;
            DataStore store = layer.getDataStore();
            x = TopologyLocator.getTopologyManager().createDataSet(layer.getName(), store);
        }
        return x;
    }

    @Override
    public int getChildCount(Object parent) {
        parent = this.getNode(parent);
        return this.deletaged.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        node = this.getNode(node);
        return this.deletaged.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.deletaged.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        parent = this.getNode(parent);
        return this.deletaged.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.deletaged.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.deletaged.removeTreeModelListener(l);
    }

    public ImageIcon getTreeIcon(Object item) {
        if (this.getRoot() == item) {
            return IconThemeHelper.getImageIcon((String)"topology-tree-project");
        }
        if (item instanceof ListElement) {
            item = ((ListElement)item).getValue();
        }
        if (this.view != null && this.view.getMapContext().getLayers() == item) {
            return IconThemeHelper.getImageIcon((String)"document-view-tree-icon");
        }
        if (item instanceof TopologyDataSet) {
            DataStore store = ((TopologyDataSet)item).getStore();
            String iconName = MapContextLocator.getMapContextManager().getIconLayer(store);
            return IconThemeHelper.getImageIcon((String)iconName);
        }
        if (item instanceof FLayer) {
            String iconName = ((FLayer)item).getTocImageIcon();
            return IconThemeHelper.getImageIcon((String)iconName);
        }
        return IconThemeHelper.getImageIcon((String)"topology-tree-folder");
    }
}

