/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodType
extends Constant {
    private int descriptor_index;

    public ConstantMethodType(ConstantMethodType c) {
        this(c.getDescriptorIndex());
    }

    ConstantMethodType(DataInput file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantMethodType(int descriptor_index) {
        super((byte)16);
        this.descriptor_index = descriptor_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantMethodType(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.descriptor_index);
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public void setDescriptorIndex(int descriptor_index) {
        this.descriptor_index = descriptor_index;
    }

    @Override
    public String toString() {
        return super.toString() + "(descriptor_index = " + this.descriptor_index + ")";
    }
}

