/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureBaseRSA;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.AbstractDOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.RSAPSSParameterSpec;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class DOMRSAPSSSignatureMethod
extends AbstractDOMSignatureMethod {
    private static final String DOM_SIGNATURE_PROVIDER = "org.jcp.xml.dsig.internal.dom.SignatureProvider";
    private static final Logger LOG = LoggerFactory.getLogger(DOMRSAPSSSignatureMethod.class);
    private final SignatureMethodParameterSpec params;
    private Signature signature;
    static final String RSA_PSS = "http://www.w3.org/2007/05/xmldsig-more#rsa-pss";
    private int trailerField = 1;
    private int saltLength = 32;
    private String digestName = "SHA-256";

    DOMRSAPSSSignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof SignatureMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type SignatureMethodParameterSpec");
        }
        if (algorithmParameterSpec == null) {
            algorithmParameterSpec = this.getDefaultParameterSpec();
        }
        this.checkParams((SignatureMethodParameterSpec)algorithmParameterSpec);
        this.params = (SignatureMethodParameterSpec)algorithmParameterSpec;
    }

    DOMRSAPSSSignatureMethod(Element element) throws MarshalException {
        Element element2 = DOMUtils.getFirstChildElement(element);
        this.params = element2 != null ? this.unmarshalParams(element2) : this.getDefaultParameterSpec();
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    @Override
    void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            if (!(signatureMethodParameterSpec instanceof RSAPSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params must be of type RSAPSSParameterSpec");
            }
            if (((RSAPSSParameterSpec)signatureMethodParameterSpec).getTrailerField() > 0) {
                this.trailerField = ((RSAPSSParameterSpec)signatureMethodParameterSpec).getTrailerField();
                LOG.debug("Setting trailerField from RSAPSSParameterSpec to: {}", this.trailerField);
            }
            if (((RSAPSSParameterSpec)signatureMethodParameterSpec).getSaltLength() > 0) {
                this.saltLength = ((RSAPSSParameterSpec)signatureMethodParameterSpec).getSaltLength();
                LOG.debug("Setting saltLength from RSAPSSParameterSpec to: {}", this.saltLength);
            }
            if (((RSAPSSParameterSpec)signatureMethodParameterSpec).getDigestName() != null) {
                this.digestName = ((RSAPSSParameterSpec)signatureMethodParameterSpec).getDigestName();
                LOG.debug("Setting digestName from RSAPSSParameterSpec to: {}", this.digestName);
            }
        }
    }

    @Override
    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    @Override
    void marshalParams(Element element, String string) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(element);
        Element element2 = document.createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:RSAPSSParams");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pss", "http://www.w3.org/2007/05/xmldsig-more#");
        Element element3 = DOMUtils.createElement(element2.getOwnerDocument(), "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", string);
        try {
            element3.setAttributeNS(null, "Algorithm", SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.fromDigestAlgorithm(this.digestName).getXmlDigestAlgorithm());
        }
        catch (XMLSignatureException | DOMException exception) {
            throw new MarshalException("Invalid digest name supplied: " + this.digestName);
        }
        element2.appendChild(element3);
        Element element4 = element2.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:SaltLength");
        Text text = element2.getOwnerDocument().createTextNode(String.valueOf(this.saltLength));
        element4.appendChild(text);
        element2.appendChild(element4);
        Element element5 = element2.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:TrailerField");
        Text text2 = element2.getOwnerDocument().createTextNode(String.valueOf(this.trailerField));
        element5.appendChild(text2);
        element2.appendChild(element5);
        element.appendChild(element2);
    }

    @Override
    SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        if (element != null) {
            SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm digestAlgorithm;
            Element element2 = XMLUtils.selectNode(element.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "SaltLength", 0);
            Element element3 = XMLUtils.selectNode(element.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "TrailerField", 0);
            int n = 1;
            if (element3 != null) {
                try {
                    n = Integer.parseInt(element3.getTextContent());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MarshalException("Invalid trailer field supplied: " + element3.getTextContent());
                }
            }
            String string = XMLUtils.selectDsNode(element.getFirstChild(), "DigestMethod", 0).getAttribute("Algorithm");
            try {
                digestAlgorithm = SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.fromXmlDigestAlgorithm(string);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new MarshalException("Invalid digest algorithm supplied: " + string);
            }
            String string2 = digestAlgorithm.getDigestAlgorithm();
            RSAPSSParameterSpec rSAPSSParameterSpec = new RSAPSSParameterSpec();
            rSAPSSParameterSpec.setTrailerField(n);
            try {
                int n2 = element2 == null ? digestAlgorithm.getSaltLength() : Integer.parseInt(element2.getTextContent());
                rSAPSSParameterSpec.setSaltLength(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MarshalException("Invalid salt length supplied: " + element2.getTextContent());
            }
            rSAPSSParameterSpec.setDigestName(string2);
            return rSAPSSParameterSpec;
        }
        return this.getDefaultParameterSpec();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean verify(Key key, SignedInfo signedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, javax.xml.crypto.dsig.XMLSignatureException {
        Object object;
        if (key == null) throw new NullPointerException();
        if (signedInfo == null) throw new NullPointerException();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                object = (Provider)xMLValidateContext.getProperty(DOM_SIGNATURE_PROVIDER);
                this.signature = object == null ? Signature.getInstance(this.getJCAAlgorithm()) : Signature.getInstance(this.getJCAAlgorithm(), (Provider)object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new javax.xml.crypto.dsig.XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.signature.initVerify((PublicKey)key);
        try {
            this.signature.setParameter(new PSSParameterSpec(this.digestName, "MGF1", new MGF1ParameterSpec(this.digestName), this.saltLength, this.trailerField));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(invalidAlgorithmParameterException);
        }
        LOG.debug("Signature provider: {}", this.signature.getProvider());
        LOG.debug("Verifying with key: {}", key);
        LOG.debug("JCA Algorithm: {}", this.getJCAAlgorithm());
        LOG.debug("Signature Bytes length: {}", byArray.length);
        try {
            object = new SignerOutputStream(this.signature);
            Throwable throwable = null;
            try {
                ((DOMSignedInfo)signedInfo).canonicalize(xMLValidateContext, (ByteArrayOutputStream)object);
                boolean bl = this.signature.verify(byArray);
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((ByteArrayOutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ByteArrayOutputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    byte[] sign(Key key, SignedInfo signedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, javax.xml.crypto.dsig.XMLSignatureException {
        Object object;
        if (key == null) throw new NullPointerException();
        if (signedInfo == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                object = (Provider)xMLSignContext.getProperty(DOM_SIGNATURE_PROVIDER);
                this.signature = object == null ? Signature.getInstance(this.getJCAAlgorithm()) : Signature.getInstance(this.getJCAAlgorithm(), (Provider)object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new javax.xml.crypto.dsig.XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.signature.initSign((PrivateKey)key);
        try {
            this.signature.setParameter(new PSSParameterSpec(this.digestName, "MGF1", new MGF1ParameterSpec(this.digestName), this.saltLength, this.trailerField));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(invalidAlgorithmParameterException);
        }
        LOG.debug("Signature provider: {}", this.signature.getProvider());
        LOG.debug("Signing with key: {}", key);
        LOG.debug("JCA Algorithm: {}", this.getJCAAlgorithm());
        try {
            object = new SignerOutputStream(this.signature);
            Throwable throwable = null;
            try {
                ((DOMSignedInfo)signedInfo).canonicalize(xMLSignContext, (ByteArrayOutputStream)object);
                byte[] byArray = this.signature.sign();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((ByteArrayOutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ByteArrayOutputStream)object).close();
                    }
                }
            }
        }
        catch (IOException | SignatureException exception) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(exception);
        }
    }

    @Override
    boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        return this.getParameterSpec().equals(algorithmParameterSpec);
    }

    private SignatureMethodParameterSpec getDefaultParameterSpec() {
        RSAPSSParameterSpec rSAPSSParameterSpec = new RSAPSSParameterSpec();
        rSAPSSParameterSpec.setTrailerField(this.trailerField);
        rSAPSSParameterSpec.setSaltLength(this.saltLength);
        rSAPSSParameterSpec.setDigestName(this.digestName);
        return rSAPSSParameterSpec;
    }

    static final class RSAPSS
    extends DOMRSAPSSSignatureMethod {
        RSAPSS(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        RSAPSS(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return DOMRSAPSSSignatureMethod.RSA_PSS;
        }

        @Override
        String getJCAAlgorithm() {
            return "RSASSA-PSS";
        }

        @Override
        AbstractDOMSignatureMethod.Type getAlgorithmType() {
            return AbstractDOMSignatureMethod.Type.RSA;
        }
    }
}

