/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.java2d.marlin.DRenderer;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderer;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererStats;
import sun.java2d.pipe.AATileGenerator;
import sun.misc.Unsafe;

final class MarlinTileGenerator
implements AATileGenerator,
MarlinConst {
    private static final boolean DISABLE_BLEND = false;
    private static final int MAX_TILE_ALPHA_SUM = TILE_W * TILE_H * MAX_AA_ALPHA;
    private static final int TH_AA_ALPHA_FILL_EMPTY = (MAX_AA_ALPHA + 1) / 3;
    private static final int TH_AA_ALPHA_FILL_FULL = (MAX_AA_ALPHA + 1) * 2 / 3;
    private static final int FILL_TILE_W = TILE_W >> 1;
    private final Renderer rdrF;
    private final DRenderer rdrD;
    private final MarlinCache cache;
    private int x;
    private int y;
    final RendererStats rdrStats;

    MarlinTileGenerator(RendererStats rendererStats, MarlinRenderer marlinRenderer, MarlinCache marlinCache) {
        this.rdrStats = rendererStats;
        if (marlinRenderer instanceof Renderer) {
            this.rdrF = (Renderer)marlinRenderer;
            this.rdrD = null;
        } else {
            this.rdrF = null;
            this.rdrD = (DRenderer)marlinRenderer;
        }
        this.cache = marlinCache;
    }

    MarlinTileGenerator init() {
        this.x = this.cache.bboxX0;
        this.y = this.cache.bboxY0;
        return this;
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        if (this.rdrF != null) {
            this.rdrF.dispose();
        } else if (this.rdrD != null) {
            this.rdrD.dispose();
        }
    }

    void getBbox(int[] nArray) {
        nArray[0] = this.cache.bboxX0;
        nArray[1] = this.cache.bboxY0;
        nArray[2] = this.cache.bboxX1;
        nArray[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return TILE_W;
    }

    @Override
    public int getTileHeight() {
        return TILE_H;
    }

    @Override
    public int getTypicalAlpha() {
        int n;
        int n2 = this.cache.alphaSumInTile(this.x);
        int n3 = n2 == 0 ? 0 : (n = n2 == MAX_TILE_ALPHA_SUM ? 255 : 128);
        if (DO_STATS) {
            this.rdrStats.hist_tile_generator_alpha.add(n);
        }
        return n;
    }

    @Override
    public void nextTile() {
        if ((this.x += TILE_W) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += TILE_H;
            if (this.y < this.cache.bboxY1) {
                if (this.rdrF != null) {
                    this.rdrF.endRendering(this.y);
                } else if (this.rdrD != null) {
                    this.rdrD.endRendering(this.y);
                }
            }
        }
    }

    @Override
    public void getAlpha(byte[] byArray, int n, int n2) {
        if (this.cache.useRLE) {
            this.getAlphaRLE(byArray, n, n2);
        } else {
            this.getAlphaNoRLE(byArray, n, n2);
        }
    }

    private void getAlphaNoRLE(byte[] byArray, int n, int n2) {
        MarlinCache marlinCache = this.cache;
        long[] lArray = marlinCache.rowAAChunkIndex;
        int[] nArray = marlinCache.rowAAx0;
        int[] nArray2 = marlinCache.rowAAx1;
        int n3 = this.x;
        int n4 = FloatMath.min(n3 + TILE_W, marlinCache.bboxX1);
        int n5 = FloatMath.min(this.y + TILE_H, marlinCache.bboxY1) - this.y;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("getAlpha = [" + n3 + " ... " + n4 + "[ [" + 0 + " ... " + n5 + "[");
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l = marlinCache.rowAAChunk.address;
        int n6 = n2 - (n4 - n3);
        int n7 = n;
        for (int i = 0; i < n5; ++i) {
            int n8;
            int n9 = n3;
            int n10 = nArray2[i];
            if (n10 > n3 && (n8 = nArray[i]) < n4) {
                int n11;
                n9 = n8;
                if (n9 <= n3) {
                    n9 = n3;
                } else {
                    for (n11 = n3; n11 < n9; ++n11) {
                        byArray[n7++] = 0;
                    }
                }
                long l2 = l + lArray[i] + (long)(n9 - n8);
                int n12 = n11 = n10 <= n4 ? n10 : n4;
                while (n9 < n11) {
                    byArray[n7++] = unsafe.getByte(l2);
                    ++l2;
                    ++n9;
                }
            }
            while (n9 < n4) {
                byArray[n7++] = 0;
                ++n9;
            }
            if (DO_TRACE) {
                for (int j = n7 - (n4 - n3); j < n7; ++j) {
                    System.out.print(MarlinTileGenerator.hex(byArray[j], 2));
                }
                System.out.println();
            }
            n7 += n6;
        }
        this.nextTile();
    }

    private void getAlphaRLE(byte[] byArray, int n, int n2) {
        byte by;
        int n3;
        int n4;
        MarlinCache marlinCache = this.cache;
        long[] lArray = marlinCache.rowAAChunkIndex;
        int[] nArray = marlinCache.rowAAx0;
        int[] nArray2 = marlinCache.rowAAx1;
        int[] nArray3 = marlinCache.rowAAEnc;
        long[] lArray2 = marlinCache.rowAALen;
        long[] lArray3 = marlinCache.rowAAPos;
        int n5 = this.x;
        int n6 = FloatMath.min(n5 + TILE_W, marlinCache.bboxX1);
        int n7 = n6 - n5;
        int n8 = FloatMath.min(this.y + TILE_H, marlinCache.bboxY1) - this.y;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("getAlpha = [" + n5 + " ... " + n6 + "[ [" + 0 + " ... " + n8 + "[");
        }
        if (n7 >= FILL_TILE_W && (n4 = n7 * n8) > 64) {
            int n9 = this.cache.alphaSumInTile(n5);
            if (n9 < n4 * TH_AA_ALPHA_FILL_EMPTY) {
                n3 = 1;
                by = 0;
            } else if (n9 > n4 * TH_AA_ALPHA_FILL_FULL) {
                n3 = 2;
                by = -1;
            } else {
                n3 = 0;
                by = 0;
            }
        } else {
            n3 = 0;
            by = 0;
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l = marlinCache.rowAAChunk.address;
        int n10 = n2 - n7;
        int n11 = n;
        switch (n3) {
            case 1: {
                Arrays.fill(byArray, n, n + n8 * n2, by);
                for (int i = 0; i < n8; ++i) {
                    long l2;
                    int n12;
                    int n13 = n5;
                    if (nArray3[i] == 0) {
                        int n14;
                        n12 = nArray2[i];
                        if (n12 > n5 && (n14 = nArray[i]) < n6) {
                            int n15;
                            n13 = n14;
                            if (n13 <= n5) {
                                n13 = n5;
                            } else {
                                n11 += n13 - n5;
                            }
                            l2 = l + lArray[i] + (long)(n13 - n14);
                            int n16 = n15 = n12 <= n6 ? n12 : n6;
                            while (n13 < n15) {
                                byArray[n11++] = unsafe.getByte(l2);
                                ++l2;
                                ++n13;
                            }
                        }
                    } else if (nArray2[i] > n5) {
                        n13 = nArray[i];
                        if (n13 > n6) {
                            n13 = n6;
                        }
                        if (n13 > n5) {
                            n11 += n13 - n5;
                        }
                        long l3 = l + lArray[i];
                        long l4 = l3 + lArray2[i];
                        l2 = l3 + lArray3[i];
                        long l5 = 0L;
                        while (n13 < n6 && l2 < l4) {
                            int n17;
                            int n18;
                            l5 = l2;
                            int n19 = unsafe.getInt(l2);
                            int n20 = n19 >> 8;
                            l2 += 4L;
                            int n21 = n13;
                            if (n21 < n5) {
                                n21 = n5;
                            }
                            if ((n18 = (n13 = n20)) > n6) {
                                n18 = n6;
                                n13 = n6;
                            }
                            if ((n17 = n18 - n21) <= 0) continue;
                            if ((n19 &= 0xFF) == 0) {
                                n11 += n17;
                                continue;
                            }
                            byte by2 = (byte)n19;
                            do {
                                byArray[n11++] = by2;
                            } while (--n17 > 0);
                        }
                        if (l5 != 0L) {
                            nArray[i] = n13;
                            lArray3[i] = l5 - l3;
                        }
                    }
                    if (n13 < n6) {
                        n11 += n6 - n13;
                    }
                    if (DO_TRACE) {
                        for (n12 = n11 - (n6 - n5); n12 < n11; ++n12) {
                            System.out.print(MarlinTileGenerator.hex(byArray[n12], 2));
                        }
                        System.out.println();
                    }
                    n11 += n10;
                }
                break;
            }
            default: {
                for (int i = 0; i < n8; ++i) {
                    long l6;
                    int n22;
                    int n23;
                    int n24 = n5;
                    if (nArray3[i] == 0) {
                        int n25;
                        n23 = nArray2[i];
                        if (n23 > n5 && (n25 = nArray[i]) < n6) {
                            n24 = n25;
                            if (n24 <= n5) {
                                n24 = n5;
                            } else {
                                for (n22 = n5; n22 < n24; ++n22) {
                                    byArray[n11++] = 0;
                                }
                            }
                            l6 = l + lArray[i] + (long)(n24 - n25);
                            int n26 = n22 = n23 <= n6 ? n23 : n6;
                            while (n24 < n22) {
                                byArray[n11++] = unsafe.getByte(l6);
                                ++l6;
                                ++n24;
                            }
                        }
                    } else if (nArray2[i] > n5) {
                        n24 = nArray[i];
                        if (n24 > n6) {
                            n24 = n6;
                        }
                        for (n22 = n5; n22 < n24; ++n22) {
                            byArray[n11++] = 0;
                        }
                        long l7 = l + lArray[i];
                        long l8 = l7 + lArray2[i];
                        l6 = l7 + lArray3[i];
                        long l9 = 0L;
                        while (n24 < n6 && l6 < l8) {
                            int n27;
                            int n28;
                            l9 = l6;
                            int n29 = unsafe.getInt(l6);
                            int n30 = n29 >> 8;
                            l6 += 4L;
                            int n31 = n24;
                            if (n31 < n5) {
                                n31 = n5;
                            }
                            if ((n28 = (n24 = n30)) > n6) {
                                n28 = n6;
                                n24 = n6;
                            }
                            if ((n27 = n28 - n31) <= 0) continue;
                            byte by3 = (byte)(n29 &= 0xFF);
                            do {
                                byArray[n11++] = by3;
                            } while (--n27 > 0);
                        }
                        if (l9 != 0L) {
                            nArray[i] = n24;
                            lArray3[i] = l9 - l7;
                        }
                    }
                    while (n24 < n6) {
                        byArray[n11++] = 0;
                        ++n24;
                    }
                    if (DO_TRACE) {
                        for (n23 = n11 - (n6 - n5); n23 < n11; ++n23) {
                            System.out.print(MarlinTileGenerator.hex(byArray[n23], 2));
                        }
                        System.out.println();
                    }
                    n11 += n10;
                }
                break;
            }
            case 2: {
                Arrays.fill(byArray, n, n + n8 * n2, by);
                for (int i = 0; i < n8; ++i) {
                    long l10;
                    int n32;
                    int n33;
                    int n34 = n5;
                    if (nArray3[i] == 0) {
                        int n35;
                        n33 = nArray2[i];
                        if (n33 > n5 && (n35 = nArray[i]) < n6) {
                            n34 = n35;
                            if (n34 <= n5) {
                                n34 = n5;
                            } else {
                                for (n32 = n5; n32 < n34; ++n32) {
                                    byArray[n11++] = 0;
                                }
                            }
                            l10 = l + lArray[i] + (long)(n34 - n35);
                            int n36 = n32 = n33 <= n6 ? n33 : n6;
                            while (n34 < n32) {
                                byArray[n11++] = unsafe.getByte(l10);
                                ++l10;
                                ++n34;
                            }
                        }
                    } else if (nArray2[i] > n5) {
                        n34 = nArray[i];
                        if (n34 > n6) {
                            n34 = n6;
                        }
                        for (n32 = n5; n32 < n34; ++n32) {
                            byArray[n11++] = 0;
                        }
                        long l11 = l + lArray[i];
                        long l12 = l11 + lArray2[i];
                        l10 = l11 + lArray3[i];
                        long l13 = 0L;
                        while (n34 < n6 && l10 < l12) {
                            int n37;
                            int n38;
                            l13 = l10;
                            int n39 = unsafe.getInt(l10);
                            int n40 = n39 >> 8;
                            l10 += 4L;
                            int n41 = n34;
                            if (n41 < n5) {
                                n41 = n5;
                            }
                            if ((n38 = (n34 = n40)) > n6) {
                                n38 = n6;
                                n34 = n6;
                            }
                            if ((n37 = n38 - n41) <= 0) continue;
                            if ((n39 &= 0xFF) == 255) {
                                n11 += n37;
                                continue;
                            }
                            byte by4 = (byte)n39;
                            do {
                                byArray[n11++] = by4;
                            } while (--n37 > 0);
                        }
                        if (l13 != 0L) {
                            nArray[i] = n34;
                            lArray3[i] = l13 - l11;
                        }
                    }
                    while (n34 < n6) {
                        byArray[n11++] = 0;
                        ++n34;
                    }
                    if (DO_TRACE) {
                        for (n33 = n11 - (n6 - n5); n33 < n11; ++n33) {
                            System.out.print(MarlinTileGenerator.hex(byArray[n33], 2));
                        }
                        System.out.println();
                    }
                    n11 += n10;
                }
            }
        }
        this.nextTile();
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(0, n2);
    }

    static {
        if (MAX_TILE_ALPHA_SUM <= 0) {
            throw new IllegalStateException("Invalid MAX_TILE_ALPHA_SUM: " + MAX_TILE_ALPHA_SUM);
        }
        if (DO_TRACE) {
            MarlinUtils.logInfo("MAX_AA_ALPHA           : " + MAX_AA_ALPHA);
            MarlinUtils.logInfo("TH_AA_ALPHA_FILL_EMPTY : " + TH_AA_ALPHA_FILL_EMPTY);
            MarlinUtils.logInfo("TH_AA_ALPHA_FILL_FULL  : " + TH_AA_ALPHA_FILL_FULL);
            MarlinUtils.logInfo("FILL_TILE_W            : " + FILL_TILE_W);
        }
    }
}

