/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.ExtendedListLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.ReportFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.repo.FileRepositoryPersistenceServiceFactory;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.RepositoryService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.impl.JRFeatureStoreDataSource;
import org.gvsig.report.lib.impl.ResourcesRepositoryService;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReport
implements Report {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReport.class);
    private final ReportConfig config;
    private DynamicReport dynamicReport;
    private SimpleJasperReportsContext jasperContext;

    public DefaultReport(ReportConfig config) {
        this.config = config;
        this.dynamicReport = null;
        this.jasperContext = null;
    }

    public DefaultReport(ReportConfig config, DynamicReport dynamicReport) {
        this(config);
        this.dynamicReport = dynamicReport;
    }

    public ReportConfig getConfig() {
        return this.config;
    }

    protected LayoutManager getLayoutManager() {
        switch (this.config.getLayoutManager()) {
            case 1: {
                return new ListLayoutManager();
            }
            case 2: {
                return new ExtendedListLayoutManager();
            }
        }
        return new ClassicLayoutManager();
    }

    public String getName() {
        return this.config.getName();
    }

    private SimpleJasperReportsContext getJasperContext() {
        if (this.jasperContext == null) {
            this.jasperContext = new SimpleJasperReportsContext();
        }
        return this.jasperContext;
    }

    private JasperReport loadJasperReport(InputStream is) {
        JasperReport jasper = null;
        try {
            SimpleJasperReportsContext context = this.getJasperContext();
            ResourcesRepositoryService resourcesRepository = new ResourcesRepositoryService(this.config.getResources());
            context.setExtensions(RepositoryService.class, Collections.singletonList(resourcesRepository));
            context.setExtensions(PersistenceServiceFactory.class, Collections.singletonList(FileRepositoryPersistenceServiceFactory.getInstance()));
            jasper = (JasperReport)JRLoader.loadObject((InputStream)is);
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn("Can't load report from config '" + this.config.toString() + "'.", (Throwable)ex);
        }
        return jasper;
    }

    public Expression getPreparedFilter(Expression filter) {
        final String prefix = this.config.getFilterFieldPrefix();
        if (StringUtils.isBlank((CharSequence)prefix) || StringUtils.isBlank((CharSequence)this.config.getFilterFieldTable())) {
            return filter;
        }
        final ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
        final ArrayList replaces = new ArrayList();
        ExpressionBuilder.Value filterValue = filter.getCode().toValue();
        filterValue.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value0) {
                ExpressionBuilder.Function func;
                if (value0 instanceof ExpressionBuilder.Function && StringUtils.equalsIgnoreCase((CharSequence)(func = (ExpressionBuilder.Function)value0).name(), (CharSequence)"GETATTR")) {
                    ExpressionBuilder.Value param0 = (ExpressionBuilder.Value)func.parameters().get(0);
                    ExpressionBuilder.Value param1 = (ExpressionBuilder.Value)func.parameters().get(1);
                    if (param0 instanceof ExpressionBuilder.Variable && param1 instanceof ExpressionBuilder.Constant && StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Variable)param0).name(), (CharSequence)DefaultReport.this.config.getFilterFieldTable())) {
                        ExpressionBuilder.Function newValue = builder.getattr(DefaultReport.this.config.getDataSetName(), prefix + ((ExpressionBuilder.Constant)param1).value());
                        replaces.add(new ImmutablePair((Object)value0, (Object)newValue));
                    }
                }
            }
        }, null);
        for (Pair replace : replaces) {
            filterValue.replace((ExpressionBuilder.Value)replace.getLeft(), (ExpressionBuilder.Value)replace.getRight());
        }
        return ExpressionUtils.createExpression((String)filterValue.toString());
    }

    public synchronized Object generateReport(SimpleTaskStatus status, Expression filter) {
        FeatureStore store = this.config.getDataSet().getStore();
        filter = this.getPreparedFilter(filter);
        UnmodifiableBasicList64 features = (UnmodifiableBasicList64)store.getFeatures(filter);
        return this.generateReport(status, (UnmodifiableBasicList64<Feature>)features);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object generateReport(final SimpleTaskStatus status, UnmodifiableBasicList64<Feature> features) {
        JasperPrint jasperPrint;
        InputStream is = null;
        try {
            JasperPrint jasperPrint2;
            JasperReport jr;
            HashMap parameters = new HashMap();
            status.message("Preparing data");
            FeatureStore store = this.config.getDataSet().getStore();
            SimpleJasperReportsContext context = this.getJasperContext();
            JRFeatureStoreDataSource dataSource = new JRFeatureStoreDataSource((JasperReportsContext)context, features, store.getStoresRepository(), store.getDefaultFeatureType());
            final long records = dataSource.size64();
            status.message("Loading template");
            if (this.dynamicReport == null) {
                is = this.config.getReportTemplateAsStream();
                if (is == null) {
                    throw new RuntimeException("Can't access to the input stream associated to the repor (" + this.config.toString() + ").");
                }
                jr = this.loadJasperReport(is);
            } else {
                jr = DynamicJasperHelper.generateJasperReport((DynamicReport)this.dynamicReport, (LayoutManager)this.getLayoutManager(), parameters);
            }
            ReportFiller filler = JRFiller.createReportFiller((JasperReportsContext)context, (JasperReport)jr);
            filler.addFillListener(new FillListener(){

                public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
                    status.message("Created page " + pageIndex + " (records " + records + ")");
                    if (pageIndex > 100000) {
                        throw new RuntimeException("Too many pages in report.");
                    }
                }

                public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
                }
            });
            status.message("Filling template");
            jasperPrint = jasperPrint2 = filler.fill(parameters, (JRDataSource)dataSource);
        }
        catch (IllegalStateException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new RuntimeException("Can't generate report.", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return jasperPrint;
    }

    public File generatePDF(SimpleTaskStatus status, Expression filter, File pdf) {
        try {
            JasperPrint jasperPrint = (JasperPrint)this.generateReport(status, filter);
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)pdf.getAbsolutePath());
            return pdf;
        }
        catch (JRException ex) {
            throw new RuntimeException("Can't export to PDF.", ex);
        }
    }
}

