/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportDataSets;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.lib.impl.DefaultReportDataSet;
import org.gvsig.report.lib.impl.DefaultReportDataSets;
import org.gvsig.report.lib.impl.DefaultReportViewCapture;
import org.gvsig.report.lib.impl.DefaultReportViewCaptures;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultReportServerConfig
implements ReportServerConfig {
    private int port;
    private int timeout;
    private String serverInfo;
    private ReportDataSets datasets;
    private boolean locked;
    private DefaultReportViewCaptures viewCaptures;
    private final PropertyChangeSupport propertyChangeSupport;
    private final ReportServices services;
    private final ReportManager manager;
    private boolean autostart;

    public DefaultReportServerConfig(ReportManager manager, ReportServices services) {
        this.services = services;
        this.manager = manager;
        this.port = 9876;
        this.timeout = 15000;
        this.serverInfo = "Test/1.1";
        this.locked = false;
        this.autostart = false;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.viewCaptures = new DefaultReportViewCaptures();
        this.viewCaptures.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportServerConfig.this.propertyChangeSupport.firePropertyChange("viewCaptures", null, null);
            }
        });
        this.datasets = new DefaultReportDataSets(manager, services);
        this.datasets.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportServerConfig.this.propertyChangeSupport.firePropertyChange("datasets", null, null);
            }
        });
    }

    public ReportServices getServices() {
        return this.services;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getPort() {
        return this.port;
    }

    public ReportServerConfig setPort(int port) {
        int oldValue = this.port;
        this.port = port;
        this.propertyChangeSupport.firePropertyChange("port", oldValue, port);
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ReportServerConfig setTimeout(int timeout) {
        int oldValue = this.timeout;
        this.timeout = timeout;
        this.propertyChangeSupport.firePropertyChange("timeout", oldValue, timeout);
        return this;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public ReportServerConfig setServerInfo(String serverInfo) {
        String oldValue = this.serverInfo;
        this.serverInfo = serverInfo;
        this.propertyChangeSupport.firePropertyChange("serverInfo", oldValue, serverInfo);
        return this;
    }

    public ReportDataSets getDatasets() {
        return this.datasets;
    }

    public ReportDataSet getDataset(String name) {
        ReportDataSet dataset = this.datasets.get(name);
        if (dataset == null) {
            DataManager dataManager = DALLocator.getDataManager();
            DataStore store = dataManager.getStoresRepository().getStore(name);
            if (store == null || !(store instanceof FeatureStore)) {
                return null;
            }
            dataset = new DefaultReportDataSet(this.services, name, (FeatureStore)store, null);
        }
        return dataset;
    }

    public String toJSON() {
        JSONObject jsonconfig = new JSONObject();
        jsonconfig.put("port", this.port);
        jsonconfig.put("timeout", this.timeout);
        jsonconfig.put("serverInfo", (Object)this.serverInfo);
        jsonconfig.put("autostart", this.autostart);
        JSONArray jsondatasets = new JSONArray();
        jsonconfig.put("datasets", (Object)jsondatasets);
        for (ReportDataSet dataset : this.datasets) {
            jsondatasets.put((Object)((DefaultReportDataSet)dataset).toJSON());
        }
        JSONArray jsonviewcaptures = new JSONArray();
        jsonconfig.put("viewcaptures", (Object)jsonviewcaptures);
        for (ReportViewCapture viewcapture : this.viewCaptures) {
            jsonviewcaptures.put((Object)((DefaultReportViewCapture)viewcapture).toJSON());
        }
        return jsonconfig.toString();
    }

    public void fromJSON(JSONObject jsonConfig) {
        DefaultReportDataSets theDatasets = new DefaultReportDataSets(this.manager, this.services);
        DefaultReportViewCaptures theViewCaptures = new DefaultReportViewCaptures();
        if (jsonConfig.has("port")) {
            this.port = jsonConfig.getInt("port");
        }
        if (jsonConfig.has("timeout")) {
            this.timeout = jsonConfig.getInt("timeout");
        }
        if (jsonConfig.has("serverInfo")) {
            this.serverInfo = jsonConfig.getString("serverInfo");
        }
        if (jsonConfig.has("autostart")) {
            this.autostart = jsonConfig.getBoolean("autostart");
        }
        if (jsonConfig.has("datasets")) {
            JSONArray jsonDatasets = jsonConfig.getJSONArray("datasets");
            for (Object jsonDataset : jsonDatasets) {
                if (!(jsonDataset instanceof JSONObject)) {
                    jsonDataset = new JSONObject(jsonDataset.toString());
                }
                DefaultReportDataSet dataset = new DefaultReportDataSet(this.getServices(), (JSONObject)jsonDataset);
                theDatasets.add(dataset);
            }
        }
        theDatasets.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportServerConfig.this.propertyChangeSupport.firePropertyChange("datasets", null, null);
            }
        });
        this.datasets = theDatasets;
        if (jsonConfig.has("viewcaptures")) {
            JSONArray jsonViewCaptures = jsonConfig.getJSONArray("viewcaptures");
            for (Object jsonViewCapture : jsonViewCaptures) {
                if (!(jsonViewCapture instanceof JSONObject)) {
                    jsonViewCapture = new JSONObject(jsonViewCapture.toString());
                }
                DefaultReportViewCapture viewCapture = new DefaultReportViewCapture(this, (JSONObject)jsonViewCapture);
                theViewCaptures.add(viewCapture);
            }
        }
        theViewCaptures.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportServerConfig.this.propertyChangeSupport.firePropertyChange("viewcaptures", null, null);
            }
        });
        this.viewCaptures = theViewCaptures;
    }

    public List<ReportViewCapture> getViewCaptures() {
        return this.viewCaptures;
    }

    public ReportViewCapture getViewCapture(String name) {
        for (ReportViewCapture viewCapture : this.viewCaptures) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)viewCapture.getName())) continue;
            return viewCapture;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean getAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean autostart) {
        boolean oldValue = this.autostart;
        this.autostart = autostart;
        this.propertyChangeSupport.firePropertyChange("autostart", oldValue, this.autostart);
    }
}

