/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.lib.impl.ReportExpressionCodeFormatter;
import org.json.JSONObject;

public class DefaultReportViewCapture
implements ReportViewCapture {
    private static int counter = 0;
    private DefaultReportViewCaptureFilter zoomFilter;
    private DefaultReportViewCaptureFilter centerFilter;
    private DefaultReportViewCaptureFilter selectFilter;
    private String name;
    private String viewName;
    private String reportDataSetName;
    private int margins;
    private boolean clearSelection;
    private Dimension dimensions;
    private int resolution;
    private final PropertyChangeSupport propertyChangeSupport;
    private final ReportServerConfig config;

    public DefaultReportViewCapture(ReportServerConfig config) {
        this.config = config;
        this.centerFilter = new DefaultReportViewCaptureFilter();
        this.centerFilter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportViewCapture.this.propertyChangeSupport.firePropertyChange("centerFilter", null, null);
            }
        });
        this.zoomFilter = new DefaultReportViewCaptureFilter();
        this.zoomFilter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportViewCapture.this.propertyChangeSupport.firePropertyChange("zoomFilter", null, null);
            }
        });
        this.selectFilter = new DefaultReportViewCaptureFilter();
        this.selectFilter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultReportViewCapture.this.propertyChangeSupport.firePropertyChange("selectFilter", null, null);
            }
        });
        this.resolution = 72;
        this.clearSelection = false;
        this.name = "capture" + counter++;
        this.viewName = null;
        this.margins = 0;
        this.dimensions = new Dimension();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public DefaultReportViewCapture(ReportServerConfig config, JSONObject json) {
        this(config);
        this.fromJSON(json);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.viewName);
    }

    public String getReportDataSet() {
        return this.reportDataSetName;
    }

    public void setReportDataSet(String reportDataSet) {
        this.reportDataSetName = reportDataSet;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", null, null);
    }

    public String getView() {
        return this.viewName;
    }

    public void setView(String view) {
        this.viewName = view;
        this.propertyChangeSupport.firePropertyChange("view", null, null);
    }

    private static String encodeForURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            return s;
        }
    }

    public String getFullURLPath() {
        StringBuilder builder = new StringBuilder();
        builder.append("/captureview/captureName/");
        builder.append(DefaultReportViewCapture.encodeForURL(this.name));
        builder.append("/viewName/");
        builder.append(DefaultReportViewCapture.encodeForURL(this.viewName));
        if (this.getResolution() > 0) {
            builder.append("/DPI/");
            builder.append(this.getResolution());
        }
        if (!this.centerFilter.isEmpty()) {
            builder.append("/center/");
            builder.append(this.centerFilter.getDataSet());
            builder.append("/");
            builder.append(this.centerFilter.getURLPart());
        }
        if (!this.zoomFilter.isEmpty()) {
            builder.append("/zoom/");
            builder.append(this.zoomFilter.getDataSet());
            builder.append("/");
            builder.append(this.zoomFilter.getURLPart());
        }
        if (!this.selectFilter.isEmpty()) {
            builder.append("/select/");
            builder.append(this.selectFilter.getDataSet());
            builder.append("/");
            builder.append(this.selectFilter.getURLPart());
        }
        if (this.margins > 0) {
            builder.append("/margins/");
            builder.append(this.margins);
        }
        if (this.clearSelection) {
            builder.append("/clearselection");
        }
        if (this.hasDimensions()) {
            builder.append("/width/");
            builder.append(this.dimensions.width);
            builder.append("/height/");
            builder.append(this.dimensions.height);
        }
        return builder.toString();
    }

    public boolean hasDimensions() {
        return this.dimensions.height > 0 || this.dimensions.width > 0;
    }

    public Dimension getDimensions() {
        return this.dimensions;
    }

    public ReportViewCapture.ReportViewCaptureFilter getZoomFilter() {
        return this.zoomFilter;
    }

    public ReportViewCapture.ReportViewCaptureFilter getCenterFilter() {
        return this.centerFilter;
    }

    public ReportViewCapture.ReportViewCaptureFilter getSelectionFilter() {
        return this.selectFilter;
    }

    public int getMargins() {
        return this.margins;
    }

    public void setMargins(int margins) {
        this.margins = margins;
        this.propertyChangeSupport.firePropertyChange("margins", null, null);
    }

    public boolean getClearSelection() {
        return this.clearSelection;
    }

    public void setClearSelection(boolean clearSelection) {
        this.clearSelection = clearSelection;
        this.propertyChangeSupport.firePropertyChange("clearSelection", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public JSONObject toJSON() {
        JSONObject me = new JSONObject();
        me.put("zoomFilter", (Object)this.zoomFilter.toJSON());
        me.put("centerFilter", (Object)this.centerFilter.toJSON());
        me.put("selectFilter", (Object)this.selectFilter.toJSON());
        me.put("viewName", (Object)this.viewName);
        me.put("reportDataSetName", (Object)this.reportDataSetName);
        me.put("clearSelection", this.clearSelection);
        me.put("dimension.width", this.dimensions.width);
        me.put("dimension.height", this.dimensions.height);
        return me;
    }

    public void fromJSON(JSONObject json) {
        this.zoomFilter = new DefaultReportViewCaptureFilter(json.getJSONObject("zoomFilter"));
        this.centerFilter = new DefaultReportViewCaptureFilter(json.getJSONObject("centerFilter"));
        this.selectFilter = new DefaultReportViewCaptureFilter(json.getJSONObject("selectFilter"));
        if (json.has("viewName")) {
            this.viewName = json.getString("viewName");
        }
        if (json.has("reportDataSetName")) {
            this.reportDataSetName = json.getString("reportDataSetName");
        }
        if (json.has("clearSelection")) {
            this.clearSelection = json.getBoolean("clearSelection");
        }
        int width = 0;
        int height = 0;
        if (json.has("dimension.width")) {
            width = json.getInt("dimension.width");
        }
        if (json.has("dimension.height")) {
            height = json.getInt("dimension.height");
        }
        this.dimensions = new Dimension(width, height);
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    private class DefaultReportViewCaptureFilter
    implements ReportViewCapture.ReportViewCaptureFilter {
        private Expression expression;
        private String datasetName;
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public DefaultReportViewCaptureFilter() {
        }

        public DefaultReportViewCaptureFilter(JSONObject json) {
            this();
            if (json.has("expression")) {
                this.expression = ExpressionUtils.createExpressionFromJSON((String)json.getString("expression"));
            }
            if (json.has("datasetName")) {
                this.datasetName = json.getString("datasetName");
            }
        }

        public JSONObject toJSON() {
            JSONObject me = new JSONObject();
            if (this.expression != null) {
                me.put("expression", (Object)this.expression.toJSON());
            }
            me.put("datasetName", (Object)StringUtils.defaultIfEmpty((CharSequence)this.datasetName, null));
            return me;
        }

        public String getURLPart() {
            if (StringUtils.isBlank((CharSequence)DefaultReportViewCapture.this.reportDataSetName)) {
                return null;
            }
            ReportDataSet dataset = DefaultReportViewCapture.this.config.getDataset(DefaultReportViewCapture.this.reportDataSetName);
            if (dataset == null) {
                return null;
            }
            ReportExpressionCodeFormatter reportformatter = new ReportExpressionCodeFormatter(dataset.getFeatureType());
            String s = this.expression.getCode().toString((Formatter)reportformatter);
            s = s.replace(" ", "+");
            return s;
        }

        public String getDataSet() {
            return this.datasetName;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setDataSet(String dataset) {
            this.datasetName = dataset;
            this.propertyChangeSupport.firePropertyChange("dataset", null, null);
        }

        public void setDataSet(ReportDataSet dataset) {
            this.datasetName = dataset == null ? null : dataset.getName();
            this.propertyChangeSupport.firePropertyChange("dataset", null, null);
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
            this.propertyChangeSupport.firePropertyChange("expression", null, null);
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((CharSequence)this.datasetName) || ExpressionUtils.isPhraseEmpty((Expression)this.expression);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }
}

