/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.reportbuilder;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.HashMap;
import java.util.List;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultGroupBuilder
implements ReportBuilder.GroupBuilder {
    private int groupLayout;
    private boolean startInNewColumn;
    private boolean startInNewPage;
    private final ReportBuilder.ColumnBuilder columnBuilder;

    public DefaultGroupBuilder(ReportBuilder.ColumnBuilder columnBuilder) {
        this.columnBuilder = columnBuilder;
        this.startInNewColumn = false;
        this.startInNewPage = false;
        this.groupLayout = 5;
    }

    public ReportBuilder.ColumnBuilder getColumnBuilder() {
        return this.columnBuilder;
    }

    public DJGroup build(HashMap<String, AbstractColumn> mapColumns, List<ReportBuilder.ColumnBuilder> columnBuilders) {
        GroupLayout dynamicJasperGroupLayout;
        GroupBuilder gb1 = new GroupBuilder();
        AbstractColumn abstractColumn = mapColumns.get(this.columnBuilder.getColumnName());
        gb1.setCriteriaColumn((PropertyColumn)abstractColumn);
        Style headerVariables = new Style();
        headerVariables.setFont(Font.ARIAL_MEDIUM_BOLD);
        headerVariables.setHorizontalAlign(HorizontalAlign.RIGHT);
        headerVariables.setVerticalAlign(VerticalAlign.MIDDLE);
        for (ReportBuilder.ColumnBuilder col : columnBuilders) {
            if (!col.showGroupByField()) continue;
            DJCalculation operation = this.getDJOperation(col.getGroupByOperation());
            AbstractColumn columnValue = mapColumns.get(col.getColumnName());
            gb1.addFooterVariable(columnValue, operation, headerVariables);
        }
        switch (this.groupLayout) {
            default: {
                dynamicJasperGroupLayout = GroupLayout.DEFAULT;
                break;
            }
            case 1: {
                dynamicJasperGroupLayout = GroupLayout.DEFAULT_WITH_HEADER;
                break;
            }
            case 2: {
                dynamicJasperGroupLayout = GroupLayout.EMPTY;
                break;
            }
            case 3: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_FOR_EACH;
                break;
            }
            case 4: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_FOR_EACH_WITH_HEADERS;
                break;
            }
            case 5: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_IN_HEADER;
                break;
            }
            case 6: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_IN_HEADER_AND_FOR_EACH;
                break;
            }
            case 7: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_IN_HEADER_AND_FOR_EACH_WITH_HEADERS;
                break;
            }
            case 8: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_IN_HEADER_WITH_HEADERS;
                break;
            }
            case 9: {
                dynamicJasperGroupLayout = GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME;
            }
        }
        gb1.setGroupLayout(dynamicJasperGroupLayout);
        return gb1.build();
    }

    private DJCalculation getDJOperation(int operation) {
        switch (operation) {
            default: {
                return DJCalculation.AVERAGE;
            }
            case 1: {
                return DJCalculation.COUNT;
            }
            case 2: {
                return DJCalculation.FIRST;
            }
            case 3: {
                return DJCalculation.HIGHEST;
            }
            case 4: {
                return DJCalculation.LOWEST;
            }
            case 5: {
                return DJCalculation.NOTHING;
            }
            case 6: {
                return DJCalculation.STANDARD_DEVIATION;
            }
            case 7: {
                return DJCalculation.SUM;
            }
            case 8: {
                return DJCalculation.SYSTEM;
            }
            case 9: 
        }
        return DJCalculation.VARIANCE;
    }

    public int getGroupLayout() {
        return this.groupLayout;
    }

    public void groupLayout(int groupLayout) {
        this.groupLayout = groupLayout;
    }

    public boolean getStartInNewColumn() {
        return this.startInNewColumn;
    }

    public void startInNewColumn(boolean startInNewColumn) {
        this.startInNewColumn = startInNewColumn;
    }

    public boolean getStartInNewPage() {
        return this.startInNewPage;
    }

    public void startInNewPage(boolean startInNewPage) {
        this.startInNewPage = startInNewPage;
    }

    public ReportBuilder.GroupBuilder clone() throws CloneNotSupportedException {
        DefaultGroupBuilder other = (DefaultGroupBuilder)super.clone();
        return other;
    }

    public void copyFrom(ReportBuilder.GroupBuilder other) {
        this.groupLayout = other.getGroupLayout();
        this.startInNewColumn = other.getStartInNewColumn();
        this.startInNewPage = other.getStartInNewPage();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
    }
}

