/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.reportbuilder;

import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import java.awt.Color;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.impl.reportbuilder.DefaultBorderBuilder;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultStyleBuilder
implements ReportBuilder.StyleBuilder {
    private Color textColor;
    private Color backgroundColor;
    private int rotation;
    private int stretching = 2;
    private boolean stretchingWithOverflow = true;
    private boolean transparent = false;
    private int verticalAlign;
    private int horizontalAlign;
    private ReportBuilder.BorderBuilder borderTop = new DefaultBorderBuilder();
    private ReportBuilder.BorderBuilder borderBottom = new DefaultBorderBuilder();
    private ReportBuilder.BorderBuilder borderLeft = new DefaultBorderBuilder();
    private ReportBuilder.BorderBuilder borderRight = new DefaultBorderBuilder();
    private int paddingTop = 2;
    private int paddingBottom = 2;
    private int paddingLeft = 2;
    private int paddingRight = 2;
    private int font = 0;
    private int fontSize = 10;
    private int transparency = 0;

    public DefaultStyleBuilder() {
        this.textColor = Color.BLACK;
        this.backgroundColor = Color.WHITE;
    }

    public ReportBuilder.StyleBuilder clone() throws CloneNotSupportedException {
        DefaultStyleBuilder other = (DefaultStyleBuilder)super.clone();
        other.borderTop = this.borderTop.clone();
        other.borderBottom = this.borderBottom.clone();
        other.borderLeft = this.borderLeft.clone();
        other.borderRight = this.borderRight.clone();
        return other;
    }

    public void copyFrom(ReportBuilder.StyleBuilder other) {
        try {
            this.font = other.getFont();
            this.fontSize = other.getFontSize();
            this.textColor = other.getTextColor();
            this.backgroundColor = other.getBackgroundColor();
            this.rotation = other.getRotation();
            this.stretching = other.getStretching();
            this.stretchingWithOverflow = other.getStretchingWithOverflow();
            this.transparency = other.getTransparency();
            this.transparent = other.getTransparent();
            this.verticalAlign = other.getVerticalAlign();
            this.horizontalAlign = other.getHorizontalAlign();
            this.paddingTop = other.getPaddingTop();
            this.paddingBottom = other.getPaddingBottom();
            this.paddingLeft = other.getPaddingLeft();
            this.paddingRight = other.getPaddingRight();
            this.borderTop = other.getBorderTop().clone();
            this.borderBottom = other.getBorderBottom().clone();
            this.borderLeft = other.getBorderLeft().clone();
            this.borderRight = other.getBorderRight().clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Can't copy Style", ex);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public ReportBuilder.StyleBuilder textColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ReportBuilder.StyleBuilder backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getRotation() {
        return this.rotation;
    }

    public ReportBuilder.StyleBuilder rotation(int rotation) {
        this.rotation = rotation;
        return this;
    }

    public int getStretching() {
        return this.stretching;
    }

    public ReportBuilder.StyleBuilder stretching(int stretching) {
        this.stretching = stretching;
        return this;
    }

    public boolean getStretchingWithOverflow() {
        return this.stretchingWithOverflow;
    }

    public ReportBuilder.StyleBuilder stretchingWithOverflow(boolean stretchingWithOverflow) {
        this.stretchingWithOverflow = stretchingWithOverflow;
        return this;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public ReportBuilder.StyleBuilder transparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public ReportBuilder.StyleBuilder transparency(int transparency) {
        this.transparency = transparency;
        return this;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public ReportBuilder.StyleBuilder verticalAlign(int verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public ReportBuilder.StyleBuilder horizontalAlign(int horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
        return this;
    }

    public ReportBuilder.BorderBuilder getBorderTop() {
        return this.borderTop;
    }

    public ReportBuilder.StyleBuilder borderTop(ReportBuilder.BorderBuilder border) {
        this.borderTop = border;
        return this;
    }

    public ReportBuilder.BorderBuilder getBorderBottom() {
        return this.borderBottom;
    }

    public ReportBuilder.StyleBuilder borderBottom(ReportBuilder.BorderBuilder border) {
        this.borderBottom = border;
        return this;
    }

    public ReportBuilder.BorderBuilder getBorderLeft() {
        return this.borderLeft;
    }

    public ReportBuilder.StyleBuilder borderLeft(ReportBuilder.BorderBuilder border) {
        this.borderLeft = border;
        return this;
    }

    public ReportBuilder.BorderBuilder getBorderRight() {
        return this.borderRight;
    }

    public ReportBuilder.StyleBuilder borderRight(ReportBuilder.BorderBuilder border) {
        this.borderRight = border;
        return this;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public ReportBuilder.StyleBuilder paddingTop(int padding) {
        this.paddingTop = padding;
        return this;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public ReportBuilder.StyleBuilder paddingBottom(int padding) {
        this.paddingBottom = padding;
        return this;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public ReportBuilder.StyleBuilder paddingLeft(int padding) {
        this.paddingLeft = padding;
        return this;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public ReportBuilder.StyleBuilder paddingRight(int padding) {
        this.paddingRight = padding;
        return this;
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
    }

    public void loadFromState(PersistentState ps) throws PersistenceException {
    }

    public static void registerPersistence() {
    }

    Style build() {
        StyleBuilder builder = new StyleBuilder(false);
        builder.setTextColor(this.textColor);
        builder.setBackgroundColor(this.backgroundColor);
        Font actualFont = new Font();
        switch (this.font) {
            default: {
                actualFont.setFontName("Arial");
                break;
            }
            case 1: {
                actualFont.setFontName("Comic Sans MS");
                break;
            }
            case 2: {
                actualFont.setFontName("Courier New");
                break;
            }
            case 3: {
                actualFont.setFontName("Georgia");
                break;
            }
            case 4: {
                actualFont.setFontName("Monospaced");
                break;
            }
            case 5: {
                actualFont.setFontName("Times New Roman");
                break;
            }
            case 6: {
                actualFont.setFontName("Verdana");
            }
        }
        actualFont.setFontSize((float)this.fontSize);
        builder.setFont(actualFont);
        switch (this.rotation) {
            default: {
                builder.setRotation(Rotation.NONE);
                break;
            }
            case 1: {
                builder.setRotation(Rotation.LEFT);
                break;
            }
            case 2: {
                builder.setRotation(Rotation.RIGHT);
            }
        }
        switch (this.stretching) {
            default: {
                builder.setStretching(Stretching.NO_STRETCH);
                break;
            }
            case 1: {
                builder.setStretching(Stretching.RELATIVE_TO_BAND_HEIGHT);
                builder.setStretchWithOverflow(this.stretchingWithOverflow);
                break;
            }
            case 2: {
                builder.setStretching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
                builder.setStretchWithOverflow(this.stretchingWithOverflow);
            }
        }
        switch (this.horizontalAlign) {
            default: {
                builder.setHorizontalAlign(HorizontalAlign.LEFT);
                break;
            }
            case 1: {
                builder.setHorizontalAlign(HorizontalAlign.CENTER);
                break;
            }
            case 2: {
                builder.setHorizontalAlign(HorizontalAlign.JUSTIFY);
                break;
            }
            case 3: {
                builder.setHorizontalAlign(HorizontalAlign.RIGHT);
            }
        }
        switch (this.verticalAlign) {
            default: {
                builder.setVerticalAlign(VerticalAlign.MIDDLE);
                break;
            }
            case 1: {
                builder.setVerticalAlign(VerticalAlign.BOTTOM);
                break;
            }
            case 2: {
                builder.setVerticalAlign(VerticalAlign.JUSTIFIED);
                break;
            }
            case 4: {
                builder.setVerticalAlign(VerticalAlign.TOP);
            }
        }
        builder.setPaddingTop(Integer.valueOf(this.paddingTop));
        builder.setPaddingBottom(Integer.valueOf(this.paddingBottom));
        builder.setPaddingLeft(Integer.valueOf(this.paddingLeft));
        builder.setPaddingRight(Integer.valueOf(this.paddingRight));
        switch (this.transparency) {
            default: {
                builder.setTransparency(Transparency.OPAQUE);
                break;
            }
            case 1: {
                builder.setTransparency(Transparency.TRANSPARENT);
            }
        }
        builder.setTransparent(this.transparent);
        builder.setBorderTop(((DefaultBorderBuilder)this.borderTop).build());
        builder.setBorderBottom(((DefaultBorderBuilder)this.borderBottom).build());
        builder.setBorderLeft(((DefaultBorderBuilder)this.borderLeft).build());
        builder.setBorderRight(((DefaultBorderBuilder)this.borderRight).build());
        return builder.build();
    }

    public int getFont() {
        return this.font;
    }

    public ReportBuilder.StyleBuilder font(int font) {
        this.font = font;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public ReportBuilder.StyleBuilder fontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }
}

