/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.wmc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.WebMapContextSettingsPanel;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;
import org.gvsig.raster.wms.app.wmsclient.wmc.WebMapContext;

public class ExportWebMapContextExtension
extends Extension {
    private static ArrayList<String> supportedVersions;
    private AbstractViewPanel viewToExport;
    private WebMapContextSettingsPanel mc;
    private static IExtension thisExtension;

    public ExportWebMapContextExtension() {
        supportedVersions = new ArrayList();
        supportedVersions.add("1.1.0");
    }

    public void initialize() {
        thisExtension = PluginServices.getExtension(ExportWebMapContextExtension.class);
    }

    public void execute(String actionCommand) {
        if (actionCommand.equals("EXPORT")) {
            DefaultViewDocument[] views = this.getExportableViews();
            if (views.length <= 0) {
                return;
            }
            this.mc = new WebMapContextSettingsPanel(views);
            PluginServices.getMDIManager().addWindow((IWindow)this.mc);
        } else if (actionCommand.equals("DO_EXPORT")) {
            String xml = this.mc.getXML();
            File f = this.mc.getTargetFile();
            if (xml != null) {
                ExportWebMapContextExtension.createFile(f, xml);
            }
        }
    }

    public static void createFile(File f, String xml) {
        if (xml != null) {
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(xml);
                bw.close();
                bw = null;
            }
            catch (IOException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)thisExtension, (String)"error_writting_file"), (Throwable)e);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        AbstractViewPanel v;
        Project project = ProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            return false;
        }
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f instanceof AbstractViewPanel && (v = (AbstractViewPanel)f) != null && v instanceof AbstractViewPanel) {
            FLayers lyrs = v.getMapControl().getMapContext().getLayers();
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                FLayer lyr = lyrs.getLayer(i);
                if (!WebMapContext.containsExportableLayers(lyr)) continue;
                this.viewToExport = v;
                return true;
            }
        }
        this.viewToExport = null;
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (int i = 0; i < views.size(); ++i) {
            DefaultViewDocument v2 = (DefaultViewDocument)views.get(i);
            if (v2 == null) continue;
            FLayers lyrs = v2.getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                FLayer lyr = lyrs.getLayer(j);
                if (!WebMapContext.containsExportableLayers(lyr)) continue;
                return true;
            }
        }
        return false;
    }

    private DefaultViewDocument[] getExportableViews() {
        Project project = ProjectManager.getInstance().getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        ArrayList<Object> exportableViews = new ArrayList<Object>();
        if (this.viewToExport != null) {
            exportableViews.add(this.viewToExport.getModel());
        }
        block0: for (int i = 0; i < views.size(); ++i) {
            DefaultViewDocument v = (DefaultViewDocument)views.get(i);
            if (v == null) continue;
            FLayers lyrs = v.getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                FLayer lyr = lyrs.getLayer(j);
                if (!(lyr instanceof FLyrWMS) || exportableViews.contains(v)) continue;
                exportableViews.add(v);
                continue block0;
            }
        }
        return exportableViews.toArray(new DefaultViewDocument[0]);
    }
}

