/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.geoprocess.lib.api.GeoProcessBuiler;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.lib.sextante.SextanteGeoProcessManager;
import org.gvsig.geoprocess.lib.sextante.core.DefaultOutputFactory;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.TableDocumentITable;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoProcessBuilerBase
implements GeoProcessBuiler {
    private static final Logger logger = LoggerFactory.getLogger(GeoProcessBuilerBase.class);
    private GeoAlgorithm algorithm;
    private AnalysisExtent extent;
    private double cellSizeZ = 1.0;
    private double cellSize = 1.0;

    public String getName() {
        if (this.algorithm == null) {
            return "unknown";
        }
        return this.algorithm.getCommandLineName();
    }

    public GeoProcessBuiler algorithm(String name) {
        SextanteGeoProcessManager manager = (SextanteGeoProcessManager)GeoProcessLocator.getGeoProcessManager();
        GeoAlgorithm alg = manager.getAlgorithms().get(name);
        if (alg == null) {
            throw new IllegalArgumentException(MessageFormat.format("Can't access to geoprocess ''{0}''.", name));
        }
        this.algorithm = alg;
        return this;
    }

    protected Parameter getParam(String name, Class expectedType, Object value) {
        Parameter param;
        try {
            param = this.algorithm.getParameters().getParameter(name);
        }
        catch (WrongParameterIDException ex) {
            throw new IllegalArgumentException(MessageFormat.format("Can't access parameter ''{0}'' of the geoprocess ''{1}''.", name, this.getName()), ex);
        }
        if (!expectedType.isInstance(param)) {
            throw new IllegalArgumentException(MessageFormat.format("Incorrect type in parameter ''{0}'' of the geoprocess ''{1}'', expected a ''{2}'', and received a ''{3}''.", name, this.getName(), param.getParameterTypeName(), value == null ? "null" : value.getClass().getSimpleName()));
        }
        return param;
    }

    public GeoProcessBuiler parameter(String name, String value) {
        Parameter param = this.getParam(name, ParameterString.class, value);
        param.setParameterValue((Object)value);
        return this;
    }

    public GeoProcessBuiler parameter(String name, int value) {
        Parameter param = this.getParam(name, ParameterNumericalValue.class, value);
        param.setParameterValue((Object)value);
        return this;
    }

    public GeoProcessBuiler parameter(String name, double value) {
        Parameter param = this.getParam(name, ParameterNumericalValue.class, value);
        param.setParameterValue((Object)value);
        return this;
    }

    public GeoProcessBuiler parameter(String name, FLyrVect value) {
        Parameter param = this.getParam(name, ParameterVectorLayer.class, value);
        FlyrVectIVectorLayer layer = new FlyrVectIVectorLayer();
        layer.create(value);
        param.setParameterValue((Object)value);
        if (this.extent == null) {
            try {
                this.extent(value.getFullEnvelope());
            }
            catch (ReadException ex) {
                logger.warn(MessageFormat.format("Can't set default extent of analysis from parameter ''{0}'' of the geoprocess ''{1}''", name, this.getName()), (Throwable)ex);
            }
        }
        return this;
    }

    public GeoProcessBuiler parameter(String name, FLyrRaster value) {
        Parameter param = this.getParam(name, ParameterRasterLayer.class, value);
        FLyrRasterIRasterLayer layer = new FLyrRasterIRasterLayer();
        layer.create(value);
        param.setParameterValue((Object)value);
        if (this.extent == null) {
            this.extent(value.getFullEnvelope());
        }
        return this;
    }

    public GeoProcessBuiler extent(Envelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            return this;
        }
        double xlow = envelope.getLowerCorner().getX();
        double ylow = envelope.getLowerCorner().getY();
        double xup = envelope.getUpperCorner().getX();
        double yup = envelope.getUpperCorner().getY();
        AnalysisExtent extent = new AnalysisExtent();
        extent.setXRange(xlow, xup, false);
        extent.setYRange(ylow, yup, false);
        extent.setZRange(0.0, 0.0, false);
        this.extent = extent;
        this.algorithm.setAnalysisExtent(extent);
        return this;
    }

    public GeoProcessBuiler cellSize(double cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    public GeoProcessBuiler cellSizeZ(double cellSizeZ) {
        this.cellSizeZ = cellSizeZ;
        return this;
    }

    public GeoProcessBuiler execute() {
        if (this.algorithm == null) {
            throw new IllegalStateException("Algorithm can't be set");
        }
        if (!this.algorithm.hasCorrectParameterValues()) {
            throw new IllegalArgumentException(MessageFormat.format("Some parameters of the process ''{0}'' has incorrect values", this.getName()));
        }
        if (this.extent != null) {
            this.extent.setCellSize(this.cellSize);
            this.extent.setCellSizeZ(this.cellSizeZ);
        }
        DefaultOutputFactory outputFactory = new DefaultOutputFactory();
        try {
            this.algorithm.execute(null, (OutputFactory)outputFactory);
        }
        catch (GeoAlgorithmExecutionException ex) {
            logger.warn(MessageFormat.format("Can't execute the process ''{0}''", this.getName()), (Throwable)ex);
        }
        return this;
    }

    public GeoProcessBuiler.OutputAccesor output() {
        return new OutputAccesorBase();
    }

    public List<String> getAlgorithmNames() {
        SextanteGeoProcessManager manager = (SextanteGeoProcessManager)GeoProcessLocator.getGeoProcessManager();
        ArrayList<String> algorithms = new ArrayList<String>(manager.getAlgorithms().keySet());
        return algorithms;
    }

    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        ParametersSet params = this.algorithm.getParameters();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            Parameter param = params.getParameter(i);
            parameterNames.add(param.getParameterName());
        }
        return parameterNames;
    }

    public GeoProcessBuiler.ParameterInfo getParameterInfo(String name) {
        Parameter param;
        try {
            param = this.algorithm.getParameters().getParameter(name);
        }
        catch (WrongParameterIDException ex) {
            throw new IllegalArgumentException(MessageFormat.format("Can't access parameter ''{0}'' of the geoprocess ''{1}''.", name, this.getName()), ex);
        }
        return new ParameterInfoBase(param);
    }

    private class OutputAccesorBase
    implements GeoProcessBuiler.OutputAccesor {
        private OutputAccesorBase() {
        }

        private Output getOutput(String name) {
            Output oo;
            OutputObjectsSet oos = GeoProcessBuilerBase.this.algorithm.getOutputObjects();
            try {
                oo = oos.getOutput(name);
            }
            catch (WrongOutputIDException ex) {
                throw new IllegalArgumentException(MessageFormat.format("Can't access to output data ''{0}'' of the geoprocess ''{1}''.", name, GeoProcessBuilerBase.this.getName()));
            }
            return oo;
        }

        public Object get(String name) {
            Output oo = this.getOutput(name);
            Object value = oo instanceof OutputRasterLayer ? this.getRasterLayer(name) : (oo instanceof OutputVectorLayer ? this.getVectorLayer(name) : (oo instanceof OutputTable ? this.getFeatureStore(name) : oo.getOutputObject()));
            return value;
        }

        public File getFile(String name) {
            Output oo = this.getOutput(name);
            FileOutputChannel channel = (FileOutputChannel)oo.getOutputChannel();
            File f = new File(channel.getFilename());
            return f;
        }

        public boolean getBoolean(String name) {
            Object o = this.get(name);
            return (Boolean)o;
        }

        public int getInt(String name) {
            Object o = this.get(name);
            return ((Number)o).intValue();
        }

        public double getDouble(String name) {
            Object o = this.get(name);
            return ((Number)o).doubleValue();
        }

        public String getString(String name) {
            Object o = this.get(name);
            return (String)o;
        }

        public FeatureStore getFeatureStore(String name) {
            Output oo = this.getOutput(name);
            if (oo instanceof OutputTable) {
                TableDocumentITable table = (TableDocumentITable)((Object)oo.getOutputObject());
                table.postProcess();
                FeatureStore store = table.getFeatureStore();
                return store;
            }
            if (oo instanceof OutputVectorLayer) {
                FlyrVectIVectorLayer slayer = (FlyrVectIVectorLayer)((Object)oo.getOutputObject());
                slayer.postProcess();
                FeatureStore store = slayer.getFeatureStore();
                return store;
            }
            return null;
        }

        public FLyrVect getVectorLayer(String name) {
            try {
                FeatureStore store = this.getFeatureStore(name);
                FLyrVect layer = (FLyrVect)MapContextLocator.getMapContextManager().createLayer(store.getName(), (DataStore)store);
                return layer;
            }
            catch (LoadLayerException ex) {
                String s = MessageFormat.format("Can't get vector layer parameter ''{0}'' of the geoprocess ''{2}''", name, GeoProcessBuilerBase.this.getName());
                logger.warn(s);
                throw new RuntimeException(s, ex);
            }
        }

        public FLyrRaster getRasterLayer(String name) {
            try {
                RasterDataStore store = this.getRasterStore(name);
                FLyrRaster layer = (FLyrRaster)MapContextLocator.getMapContextManager().createLayer(store.getName(), (DataStore)store);
                return layer;
            }
            catch (LoadLayerException ex) {
                String s = MessageFormat.format("Can't get raster layer parameter ''{0}'' of the geoprocess ''{2}''", name, GeoProcessBuilerBase.this.getName());
                logger.warn(s);
                throw new RuntimeException(s, ex);
            }
        }

        public RasterDataStore getRasterStore(String name) {
            Output oo = this.getOutput(name);
            FileOutputChannel channel = (FileOutputChannel)oo.getOutputChannel();
            File rasterFile = new File(channel.getFilename());
            String storeProviderName = null;
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)DALLocator.getDataManager().getServerExplorerRegister().getFactory("FilesystemExplorer");
            Iterator it = explorer.getFilters();
            while (it.hasNext()) {
                FilesystemServerExplorerProvider provider = (FilesystemServerExplorerProvider)it.next();
                if (!provider.accept(rasterFile)) continue;
                storeProviderName = provider.getDataStoreProviderName();
                break;
            }
            if (storeProviderName == null) {
                String s = MessageFormat.format("Can't get raster store ''{0}'', type ''{1}'', of the geoprocess ''{2}''. Can't locate store for open file ''{3}''.", name, oo.getClass().getSimpleName(), GeoProcessBuilerBase.this.getName(), rasterFile.getAbsolutePath());
                logger.warn(s);
                throw new RuntimeException(s);
            }
            try {
                DataManager dataManager = DALLocator.getDataManager();
                DataStoreParameters params = dataManager.createStoreParameters(storeProviderName);
                ((FilesystemStoreParameters)params).setFile(rasterFile);
                RasterDataStore store = (RasterDataStore)dataManager.openStore(storeProviderName, params);
                return store;
            }
            catch (Exception ex) {
                String s = MessageFormat.format("Can't get output raster store ''{0}'', type ''{1}'', of the geoprocess ''{2}''. Can't open store for file ''{3}''.", name, oo.getClass().getSimpleName(), GeoProcessBuilerBase.this.getName(), rasterFile.getAbsolutePath());
                logger.warn(s);
                throw new RuntimeException(s, ex);
            }
        }
    }

    private class ParameterInfoBase
    implements GeoProcessBuiler.ParameterInfo {
        private final Parameter param;

        public ParameterInfoBase(Parameter param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getParameterName();
        }

        public String getTypeName() {
            return this.param.getParameterTypeName();
        }

        public String getDescription() {
            return this.param.getParameterDescription();
        }

        public String getTooltip() {
            return this.param.getParameterTooltip();
        }

        public Class getParameterClass() {
            return this.param.getParameterClass();
        }

        public String getDetailedDescription() {
            try {
                AdditionalInfo x = this.param.getParameterAdditionalInfo();
                if (x == null) {
                    return null;
                }
                return x.getTextDescription();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

