/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.core;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.additionalResults.AdditionalResults;
import es.unex.sextante.gui.algorithm.iterative.SingleFeatureVectorLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.NullOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputText;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.ReloadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FileTools;
import org.gvsig.raster.fmap.layers.FLyrRaster;

public class PostProcessTaskRunnable
implements Runnable {
    private MapContext m_MapContext;
    private final GeoAlgorithm m_Algorithm;
    private final OutputObjectsSet m_Output;
    private final boolean m_bShowResultsWindows;

    public PostProcessTaskRunnable(GeoAlgorithm algorithm, boolean bShowResultsWindow) {
        this.m_Output = algorithm.getOutputObjects();
        this.m_Algorithm = algorithm;
        this.m_bShowResultsWindows = bShowResultsWindow;
    }

    @Override
    public void run() {
        if (this.m_Output.hasLayers()) {
            this.setOutputView();
        }
        this.addResults();
    }

    private void setOutputView() {
        ViewDocument view = null;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter param = parameters.getParameter(i);
            Object object = param.getParameterValueAsObject();
            if (object instanceof ILayer) {
                view = this.getViewFromLayer((ILayer)object);
                this.m_MapContext = view.getMapContext();
                return;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (int j = 0; j < list.size(); ++j) {
                Object obj = list.get(j);
                if (obj instanceof ILayer) {
                    view = this.getViewFromLayer((ILayer)obj);
                    this.m_MapContext = view.getMapContext();
                    return;
                }
                if (!(obj instanceof RasterLayerAndBand)) continue;
                RasterLayerAndBand rlab = (RasterLayerAndBand)obj;
                view = this.getViewFromLayer((ILayer)rlab.getRasterLayer());
                this.m_MapContext = view.getMapContext();
                return;
            }
        }
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        Object[] options = new Object[views.size() + 1];
        options[0] = Sextante.getText((String)"Create_new_view");
        for (int i = 0; i < views.size(); ++i) {
            options[i + 1] = views.get(i);
        }
        Object selectedObject = JOptionPane.showInputDialog(null, Sextante.getText((String)"Select_output_view"), Sextante.getText((String)"Output_view"), -1, null, options, null);
        if (selectedObject instanceof ViewDocument) {
            this.m_MapContext = ((ViewDocument)selectedObject).getMapContext();
        } else {
            final Document newView = ProjectManager.getInstance().createDocument(ViewManager.TYPENAME, "SEXTANTE (" + this.m_Algorithm.getName() + ")");
            ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject().add(newView);
            final IWindow window = newView.getFactory().getMainWindow(newView);
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    PluginServices.getMDIManager().addWindow(window);
                    PostProcessTaskRunnable.this.m_MapContext = ((ViewDocument)newView).getMapContext();
                }
            };
            try {
                SwingUtilities.invokeAndWait(doWorkRunnable);
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private ViewDocument getViewFromLayer(ILayer layer) {
        if (layer instanceof SingleFeatureVectorLayer) {
            layer = ((SingleFeatureVectorLayer)layer).getOriginalLayer();
        }
        FLayer gvSIGBaseLayer = (FLayer)layer.getBaseDataObject();
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        List docs = project.getDocuments(ViewManager.TYPENAME);
        for (int i = 0; i < docs.size(); ++i) {
            ViewDocument viewDoc = (ViewDocument)docs.get(i);
            FLayers layers = viewDoc.getMapContext().getLayers();
            LayersIterator iter = new LayersIterator((FLayer)layers);
            while (iter.hasNext()) {
                FLayer gvSIGLayer = iter.nextLayer();
                if (!gvSIGLayer.equals(gvSIGBaseLayer)) continue;
                return viewDoc;
            }
        }
        return null;
    }

    private void addResults() {
        boolean bUseInternalNames = new Boolean(SextanteGUI.getSettingParameterValue((String)"UseInternalNames"));
        boolean bModiFyResultsNames = new Boolean(SextanteGUI.getSettingParameterValue((String)"ModifyNames"));
        boolean bInvalidate = false;
        boolean bShowAdditionalPanel = false;
        if (this.m_MapContext != null) {
            this.m_MapContext.beginAtomicEvent();
        }
        for (int i = 0; i < this.m_Output.getOutputObjectsCount(); ++i) {
            String sFilename;
            Output out = this.m_Output.getOutput(i);
            String sDescription = out.getDescription();
            IOutputChannel channel = out.getOutputChannel();
            Object object = out.getOutputObject();
            if (out instanceof OutputRasterLayer || out instanceof Output3DRasterLayer || out instanceof OutputTable || out instanceof OutputVectorLayer) {
                if (bUseInternalNames) {
                    sDescription = out.getName();
                } else if (bModiFyResultsNames) {
                    sDescription = SextanteGUI.modifyResultName((String)sDescription);
                }
                if (channel instanceof NullOutputChannel || channel == null) continue;
            }
            if (out instanceof OutputVectorLayer) {
                FLyrVect flayer;
                sFilename = null;
                if (channel instanceof FileOutputChannel) {
                    sFilename = ((FileOutputChannel)channel).getFilename();
                    flayer = (FLyrVect)FileTools.openLayer(sFilename, sDescription, (IProjection)this.m_Algorithm.getOutputCRS());
                    flayer.setTemporary(((FileOutputChannel)channel).isTemporary());
                    if (flayer != null) {
                        flayer.setName(sDescription);
                        this.m_MapContext.getLayers().addLayer((FLayer)flayer);
                        bInvalidate = true;
                    }
                } else if (channel instanceof OverwriteOutputChannel) {
                    flayer = (FLyrVect)((OverwriteOutputChannel)channel).getLayer().getBaseDataObject();
                    try {
                        flayer.reload();
                        bInvalidate = true;
                    }
                    catch (ReloadLayerException reloadLayerException) {
                        // empty catch block
                    }
                }
                if (object == null) continue;
                ((IVectorLayer)object).close();
                continue;
            }
            if (out instanceof OutputTable) {
                try {
                    sFilename = ((FileOutputChannel)channel).getFilename();
                    TableDocument table = FileTools.openTable(sFilename, sDescription);
                    if (table == null) continue;
                    table.setName(sDescription);
                    ApplicationLocator.getManager().getProjectManager().getCurrentProject().add((Document)table);
                }
                catch (Exception e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                continue;
            }
            if (out instanceof OutputRasterLayer) {
                String sFilename2;
                FLyrRaster flayer;
                IRasterLayer rasterLayer = (IRasterLayer)object;
                if (!(channel instanceof FileOutputChannel) || (flayer = (FLyrRaster)FileTools.openLayer(sFilename2 = ((FileOutputChannel)channel).getFilename(), sDescription, (IProjection)this.m_Algorithm.getOutputCRS())) == null) continue;
                if (rasterLayer != null) {
                    try {
                        NoData nodata = RasterLocator.getManager().getDataStructFactory().createNoData((Number)rasterLayer.getNoDataValue(), null, sFilename2);
                        if (flayer.getDataStore().getDataType()[0] == 0) {
                            nodata.setNoDataTransparent(false);
                        }
                        flayer.setNoDataValue(nodata);
                        nodata.save();
                        rasterLayer.close();
                    }
                    catch (Exception e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                flayer.setName(sDescription);
                this.m_MapContext.getLayers().addLayer((FLayer)flayer);
                bInvalidate = true;
                continue;
            }
            if (out instanceof OutputText) {
                JTextPane jTextPane = new JTextPane();
                jTextPane.setEditable(false);
                jTextPane.setContentType("text/html");
                jTextPane.setText((String)object);
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setViewportView(jTextPane);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jTextPane.setBorder(BorderFactory.createEtchedBorder(1));
                AdditionalResults.addComponent((ObjectAndDescription)new ObjectAndDescription(sDescription, (Object)jScrollPane));
                bShowAdditionalPanel = true;
                continue;
            }
            if (object instanceof Component) {
                AdditionalResults.addComponent((ObjectAndDescription)new ObjectAndDescription(sDescription, object));
                bShowAdditionalPanel = true;
                continue;
            }
            if (!(out instanceof Output3DRasterLayer)) continue;
            JOptionPane.showMessageDialog(SextanteGUI.getMainFrame(), Sextante.getText((String)"3d_not_supported"), Sextante.getText((String)"Warning"), 2);
        }
        if (this.m_MapContext != null) {
            this.m_MapContext.endAtomicEvent();
        }
        if (bInvalidate) {
            this.m_MapContext.invalidate();
        }
        if (bShowAdditionalPanel && this.m_bShowResultsWindows) {
            AdditionalResults.showPanel();
        }
    }
}

