/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.AbstractRasterLayer;
import es.unex.sextante.outputs.IOutputChannel;
import java.awt.geom.Rectangle2D;
import java.io.File;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;

public class FLyrRasterIRasterLayer
extends AbstractRasterLayer {
    private FLyrRaster lyr = null;
    private Buffer m_Buffer = null;
    private int xTranslate = 0;
    private int yTranslate = 0;
    private AnalysisExtent layerExtent = null;
    private String fName = null;

    public FLyrRasterIRasterLayer() {
    }

    public FLyrRasterIRasterLayer(String fName) {
        this.fName = fName;
    }

    public void create(FLyrRaster lyr) {
        this.lyr = lyr;
    }

    private RasterDataStore getDataStore() {
        return this.lyr == null ? null : this.lyr.getDataStore();
    }

    public int getDataType() {
        return this.getDataStore().getDataType()[0];
    }

    public void setCellValue(int x, int y, int iBand, double dValue) {
    }

    public void setNoDataValue(double dNoDataValue) {
        this.getDataStore().getNoDataValue().setValue((Number)dNoDataValue);
    }

    public void setNoData(int x, int y) {
    }

    public double getNoDataValue() {
        if (this.getDataStore().getNoDataValue().getValue() != null) {
            return this.getDataStore().getNoDataValue().getValue().doubleValue();
        }
        return -99999.0;
    }

    public double getCellValueInLayerCoords(int x, int y, int iBand) {
        int newx = x - this.xTranslate;
        int newy = y - this.yTranslate;
        if (this.m_Buffer == null) {
            this.open();
        }
        if (this.m_Buffer.isInside(newx, newy)) {
            switch (this.getDataStore().getDataType()[0]) {
                case 0: {
                    return this.m_Buffer.getElemByte(newy, newx, iBand) & 0xFF;
                }
                case 2: {
                    return this.m_Buffer.getElemShort(newy, newx, iBand);
                }
                case 3: {
                    return this.m_Buffer.getElemInt(newy, newx, iBand);
                }
                case 4: {
                    return this.m_Buffer.getElemFloat(newy, newx, iBand);
                }
            }
            return this.m_Buffer.getElemDouble(newy, newx, iBand);
        }
        return this.getNoDataValue();
    }

    public int getBandsCount() {
        return this.getDataStore().getBandCount();
    }

    public String getName() {
        if (this.lyr != null) {
            return this.lyr.getName();
        }
        if (this.getDataStore() != null) {
            String uri = this.getDataStore().getName();
            if (uri.contains(File.separator)) {
                int index = uri.lastIndexOf(File.separator);
                return uri.substring(index + 1);
            }
            return uri;
        }
        return null;
    }

    public void postProcess() {
    }

    public void open() {
        if (this.getDataStore() == null) {
            this.setBaseDataObject(this.fName);
        }
        RasterQuery query = RasterLocator.getManager().createQuery();
        query.setAllDrawableBands();
        try {
            query.setAreaOfInterest();
            query.setReadOnly(true);
            this.m_Buffer = this.getDataStore().query(query);
        }
        catch (QueryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (ProcessInterruptedException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void close() {
        if (this.m_Buffer != null) {
            this.m_Buffer.dispose();
        }
    }

    public Rectangle2D getFullExtent() {
        return this.getDataStore().getExtent().toRectangle2D();
    }

    public AnalysisExtent getLayerGridExtent() {
        if (this.layerExtent == null) {
            try {
                this.layerExtent = new AnalysisExtent();
                this.layerExtent.setCellSize(this.getDataStore().getCellSize());
                Extent bbox = this.getDataStore().getExtent();
                this.layerExtent.setXRange(bbox.getMin().getX(), bbox.getMax().getX(), true);
                this.layerExtent.setYRange(bbox.getMin().getY(), bbox.getMax().getY(), true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.layerExtent;
    }

    public void setWindowExtent(AnalysisExtent extent) {
        super.setWindowExtent(extent);
        RasterManager rManager = RasterLocator.getManager();
        RasterQuery query = rManager.createQuery();
        query.setReadOnly(true);
        int[] bands = new int[this.getDataStore().getBandCount()];
        for (int i = 0; i < this.getDataStore().getBandCount(); ++i) {
            bands[i] = i;
        }
        query.setDrawableBands(bands);
        Extent ext = RasterLocator.getManager().getDataStructFactory().createExtent(extent.getXMin(), extent.getYMax(), extent.getXMax(), extent.getYMin());
        query.setAreaOfInterest(ext, extent.getNX(), extent.getNY());
        Buffer entireBuf = this.m_Buffer;
        try {
            this.m_Buffer = this.getDataStore().query(query);
            Extent bbox = this.getDataStore().getExtent();
            double distx = extent.getXMin() - bbox.getMin().getX();
            double disty = bbox.getMax().getY() - extent.getYMax();
            this.xTranslate = (int)Math.round(distx * (double)extent.getNX() / (extent.getXMax() - extent.getXMin()));
            this.yTranslate = (int)Math.round(disty * (double)extent.getNY() / (extent.getYMax() - extent.getYMin()));
        }
        catch (QueryException e) {
            this.m_Buffer = entireBuf;
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    public double getLayerCellSize() {
        return this.getDataStore().getCellSize();
    }

    public Object getCRS() {
        return this.getDataStore().getProjection();
    }

    public void setName(String name) {
        this.lyr.setName(name);
    }

    public void free() {
        if (this.m_Buffer != null) {
            this.m_Buffer.dispose();
        }
        try {
            this.getDataStore().close();
        }
        catch (CloseException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public Object getBaseDataObject() {
        return this.lyr;
    }

    public void setBaseDataObject(FLyrRaster lyr) {
        this.lyr = lyr;
    }

    public void setBaseDataObject(RasterDataStore store) {
        DefaultFLyrRaster lyr = new DefaultFLyrRaster();
        try {
            lyr.setDataStore((DataStore)store);
        }
        catch (LoadLayerException e) {
            Sextante.addErrorToLog((Throwable)e);
            return;
        }
        this.lyr = lyr;
    }

    public void setBaseDataObject(String fileName) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            RasterFileStoreParameters params = (RasterFileStoreParameters)dataManager.createStoreParameters("Gdal Store");
            params.setURI(new File(fileName).toURI());
            RasterDataStore dataStore = (RasterDataStore)dataManager.openStore(params.getDataStoreName(), (DataStoreParameters)params);
            this.setBaseDataObject(dataStore);
        }
        catch (ValidateDataParametersException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (InitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public IOutputChannel getOutputChannel() {
        return new IOutputChannel(){

            public String getAsCommandLineParameter() {
                return FLyrRasterIRasterLayer.this.lyr.getName();
            }
        };
    }
}

