/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jgdal;

import java.io.IOException;
import java.util.Vector;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.ogr.ogr;
import org.gvsig.jgdal.GdalDriver;
import org.gvsig.jgdal.GdalException;
import org.gvsig.jgdal.GdalRasterBand;
import org.gvsig.jgdal.GeoTransform;
import org.gvsig.jogr.OGRTools;

public class GdalDataset {
    public static int GA_ReadOnly = 0;
    public static int GA_Update = 1;
    public static int GDT_Unknown = 0;
    public static int GDT_Byte = 1;
    public static int GDT_UInt16 = 2;
    public static int GDT_Int16 = 3;
    public static int GDT_UInt32 = 4;
    public static int GDT_Int32 = 5;
    public static int GDT_Float32 = 6;
    public static int GDT_Float64 = 7;
    public static int GDT_CInt16 = 8;
    public static int GDT_CInt32 = 9;
    public static int GDT_CFloat32 = 10;
    public static int GDT_CFloat64 = 11;
    public static int GDT_TypeCount = 12;
    private Dataset dataset;

    public GdalDataset() {
    }

    public GdalDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public void open(String filename, int access) throws GdalException, IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        if (access < 0 || access > 1) {
            throw new GdalException("Access type mistmatch (access=" + access + ").");
        }
        this.dataset = gdal.Open((String)filename, (int)access);
        if (this.dataset == null) {
            throw new GdalException("Can't open file '" + filename + "'.");
        }
    }

    public String[] getMetadata() throws GdalException {
        return this.getMetadata(null);
    }

    public String[] getMetadata(String domain) throws GdalException {
        Vector res = this.dataset.GetMetadata_List(domain);
        if (res == null) {
            return new String[0];
        }
        return OGRTools.safeVectorToStringArray(res);
    }

    public GdalRasterBand getRasterBand(int hBand) throws GdalException {
        if (hBand < 1 || hBand > this.getRasterCount()) {
            throw new GdalException("Banda seleccionada incorrecta");
        }
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        Band rb = this.dataset.GetRasterBand(hBand);
        return new GdalRasterBand(rb);
    }

    public int getRasterXSize() {
        return this.dataset.getRasterXSize();
    }

    public int getRasterYSize() {
        return this.dataset.getRasterYSize();
    }

    public int getRasterCount() {
        return this.dataset.getRasterCount();
    }

    public GeoTransform getGeoTransform() throws GdalException {
        GeoTransform gt = new GeoTransform();
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        this.dataset.GetGeoTransform(gt.adfgeotransform);
        if (gt.isIdentity()) {
            throw new GeoTransform.GeoTransformException("Error en getGeoTransform(). No se han obtenido valores para geoTransform.");
        }
        return gt;
    }

    public String getDriverShortName() throws GdalException {
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        String shortName = this.dataset.GetDriver().getShortName();
        if (shortName == null) {
            throw new GdalException("Error en getDriverShortName(). No ha podido obtenerse el driver");
        }
        return shortName;
    }

    public void setGeoTransform(GeoTransform gt) throws GdalException {
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        if (gt == null) {
            throw new GdalException("el objeto es null");
        }
        int res = this.dataset.SetGeoTransform(gt.adfgeotransform);
    }

    public String getProjectionRef() throws GdalException {
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        String res = this.dataset.GetProjectionRef();
        if (res == null) {
            return new String("");
        }
        return res;
    }

    public void close() throws GdalException {
        this.dataset.delete();
    }

    public static GdalDriver getDriverByName(String name) throws GdalException {
        if (name == null) {
            throw new GdalException("El nombre del driver es null");
        }
        gdal.AllRegister();
        ogr.RegisterAll();
        Driver ptrdrv = gdal.GetDriverByName((String)name);
        return new GdalDriver(ptrdrv);
    }

    public int getGCPCount() throws GdalException {
        return this.dataset.GetGCPCount();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setProjection(String proj) throws GdalException {
        if (this.dataset == null) {
            throw new GdalException("No se ha podido acceder al archivo.");
        }
        if (proj == null) {
            throw new GdalException("La proyeccion es null");
        }
        int res = this.dataset.SetProjection(proj);
        if (res < 0) {
            throw new GdalException("Error en setProjection(). No se ha podido asignar la proyecci?n.");
        }
    }

    public String getColorInterpretationName(int colorInterp) throws GdalException {
        if (colorInterp < 0 || colorInterp > 16) {
            throw new GdalException("Valor de interpretacion de color fuera de rango");
        }
        String bandTypeName = gdal.GetColorInterpretationName((int)colorInterp);
        if (bandTypeName == null) {
            throw new GdalException("Error en getColorInterpretationName(). No ha podido obtenerse el tipo de banda de color");
        }
        return bandTypeName;
    }
}

