/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.jgdal.GdalBuffer;
import org.gvsig.jgdal.GdalDataset;
import org.gvsig.jgdal.GdalDriver;
import org.gvsig.jgdal.GdalException;
import org.gvsig.jgdal.GdalRasterBand;
import org.gvsig.jgdal.GeoTransform;
import org.gvsig.raster.gdal.io.GdalDataParameters;
import org.gvsig.raster.gdal.io.GdalDataSource;
import org.gvsig.raster.gdal.io.GdalProvider;
import org.gvsig.raster.gdal.io.features.BMPFeatures;
import org.gvsig.raster.gdal.io.features.GTiffFeatures;
import org.gvsig.raster.gdal.io.features.HFAFeatures;
import org.gvsig.raster.gdal.io.features.IDRISIFeatures;
import org.gvsig.raster.gdal.io.features.ILWIS_MprFeatures;
import org.gvsig.raster.gdal.io.features.Jpeg2000Features;
import org.gvsig.raster.gdal.io.features.PNM_PgmFeatures;
import org.gvsig.raster.gdal.io.features.PNM_PpmFeatures;
import org.gvsig.raster.impl.buffer.DefaultDataServerWriter;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.store.ParamImpl;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.impl.store.WriteFileFormatFeatures;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.writer.DefaultRasterWriter;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdalWriter
extends DefaultRasterWriter {
    private static final Logger logger = LoggerFactory.getLogger(GdalWriter.class);
    private GdalDriver drv;
    private GdalDataset dstDataset = null;
    private GdalRasterBand rband = null;
    private GeoTransform geot = null;
    private GdalBuffer[] bufBands = null;
    private int nBlocks = 0;
    private int anchoResto = 0;
    private boolean write = true;
    private int dataType = 32;

    public static void register() {
        DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        point.append("tif", "", GdalWriter.class);
        pInfo.getFileFeature().put("tif", new GTiffFeatures());
        point.append("img", "", GdalWriter.class);
        pInfo.getFileFeature().put("img", new HFAFeatures());
        point.append("bmp", "", GdalWriter.class);
        pInfo.getFileFeature().put("bmp", new BMPFeatures());
        point.append("pgm", "", GdalWriter.class);
        pInfo.getFileFeature().put("pgm", new PNM_PgmFeatures());
        point.append("ppm", "", GdalWriter.class);
        pInfo.getFileFeature().put("ppm", new PNM_PpmFeatures());
        point.append("mpl", "", GdalWriter.class);
        pInfo.getFileFeature().put("mpl", new ILWIS_MprFeatures());
        point.append("rst", "", GdalWriter.class);
        pInfo.getFileFeature().put("rst", new IDRISIFeatures());
        point.append("jp2", "", GdalWriter.class);
        pInfo.getFileFeature().put("jp2", new Jpeg2000Features());
    }

    public void loadParams(String ident) {
        WriteFileFormatFeatures wfff = (WriteFileFormatFeatures)this.pInfo.getFileFeature().get(ident);
        wfff.loadParams();
        this.driverParams = (ParamsImpl)wfff.getParams();
    }

    public String getProviderName() {
        return GdalProvider.NAME;
    }

    public GdalWriter(String fileName) {
        this.ident = this.fileUtil.getExtensionFromFileName(fileName);
        this.driver = ((WriteFileFormatFeatures)this.pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.loadParams(this.ident);
    }

    public GdalWriter(DataServerWriter dataWriter, String outFileName, Integer nBands, AffineTransform at, Integer outSizeX, Integer outSizeY, Integer dataType, Params params, IProjection proj) throws GdalException, IOException {
        this(dataWriter, outFileName, nBands, at, outSizeX, outSizeY, dataType, params, proj, new Boolean(true));
    }

    public GdalWriter(DataServerWriter dataWriter, String outFileName, Integer nBands, AffineTransform at, Integer outSizeX, Integer outSizeY, Integer dataType, Params params, IProjection proj, Boolean geo) throws GdalException, IOException {
        this.proj = proj;
        this.ident = outFileName.toLowerCase().substring(outFileName.lastIndexOf(".") + 1);
        this.driver = ((WriteFileFormatFeatures)this.pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.dataType = dataType;
        this.at = at;
        this.percent = 0;
        this.dataWriter = dataWriter;
        this.outFileName = outFileName;
        this.sizeWindowX = outSizeX;
        this.sizeWindowY = outSizeY;
        if (this.sizeWindowX < 0 || this.sizeWindowY < 0) {
            throw new IOException("Tama\u00f1o del fichero de salida erroneo.");
        }
        this.nBands = nBands;
        this.geot = new GeoTransform();
        this.geot.adfgeotransform[0] = at.getTranslateX();
        this.geot.adfgeotransform[3] = at.getTranslateY();
        this.geot.adfgeotransform[1] = at.getScaleX();
        this.geot.adfgeotransform[5] = at.getScaleY();
        this.geot.adfgeotransform[2] = at.getShearX();
        this.geot.adfgeotransform[4] = at.getShearY();
        String outRmf = outFileName.substring(0, outFileName.lastIndexOf("."));
        if (geo.booleanValue()) {
            this.rasterUtil.saveGeoInfo(outRmf, at, (Point2D)new Point2D.Double(this.sizeWindowX, this.sizeWindowY));
        }
        if (params == null) {
            this.loadParams(this.ident);
        } else if (params instanceof ParamsImpl) {
            this.driverParams = (ParamsImpl)params;
        }
        this.init();
    }

    public void setWkt(String wkt) {
        if (this.dstDataset != null && wkt != null && wkt.compareTo("unknown") != 0) {
            try {
                this.dstDataset.setProjection(wkt);
            }
            catch (GdalException e) {
                System.err.println("Proyecci\u00f3n Wkt no asignada en GdalWriter");
                return;
            }
        }
    }

    public void setDriverType(String drvType) {
        this.driver = drvType;
    }

    private void init() throws GdalException {
        if (this.driver == null) {
            throw new GdalException("Tipo de driver sin especificar.");
        }
        boolean okdrvtype = false;
        String[] types = this.pInfo.getWriteDriversType();
        for (int i = 0; i < this.pInfo.getWriteNTypes(); ++i) {
            if (!this.driver.equals(types[i])) continue;
            okdrvtype = true;
        }
        if (!okdrvtype) {
            throw new GdalException("El tipo de driver " + this.driver + " no est\u00e1 soportado por GdalWriter.");
        }
        this.drv = GdalDataset.getDriverByName(this.driver);
        if (this.dstDataset != null) {
            this.dstDataset.close();
            this.dstDataset = null;
        }
        this.dstDataset = this.drv.create(this.outFileName, this.sizeWindowX, this.sizeWindowY, this.nBands, GdalDataSource.getGdalTypeFromRasterBufType(this.dataType), this.gdalParamsFromRasterParams(this.driverParams));
        this.dstDataset.setGeoTransform(this.geot);
        int blockSize = RasterLibrary.blockHeight;
        if (this.dataWriter.getBuffer() != null && this.dataWriter.getBuffer().isCached()) {
            blockSize = this.dataWriter.getBuffer().getBlockHeight();
        }
        this.nBlocks = this.sizeWindowY / blockSize;
        this.anchoResto = this.sizeWindowY - this.nBlocks * blockSize;
    }

    public void anotherFile(String fileName) throws GdalException {
        this.dstDataset = this.drv.create(fileName, this.sizeWindowX, this.sizeWindowY, this.nBands, GdalDataSource.getGdalTypeFromRasterBufType(this.dataType), this.gdalParamsFromRasterParams(this.driverParams));
    }

    public String[] gdalParamsFromRasterParams(Params p) {
        ParamImpl prog;
        ParamImpl qt;
        ParamImpl th;
        ParamImpl tw;
        ParamImpl mtw;
        ParamImpl rrd;
        ParamImpl comp1;
        ParamImpl comp;
        ParamImpl inter;
        if (p == null) {
            return null;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        ParamImpl phot = (ParamImpl)p.getParamById("photometric");
        if (phot != null) {
            paramList.add("PHOTOMETRIC=" + phot.getList()[(Integer)phot.getDefaultValue()]);
        }
        if ((inter = (ParamImpl)p.getParamById("interleave")) != null) {
            paramList.add("INTERLEAVE=" + inter.getList()[(Integer)inter.getDefaultValue()]);
        }
        if ((comp = (ParamImpl)p.getParamById("compression")) != null) {
            paramList.add("COMPRESS=" + comp.getList()[(Integer)comp.getDefaultValue()]);
        }
        if ((comp1 = (ParamImpl)p.getParamById("compress")) != null) {
            paramList.add("COMPRESS=" + comp1.getList()[(Integer)comp1.getDefaultValue()]);
        }
        if ((rrd = (ParamImpl)p.getParamById("rrd")) != null) {
            paramList.add("HFA_USE_RRD=" + rrd.getList()[(Integer)rrd.getDefaultValue()]);
        }
        if ((mtw = (ParamImpl)p.getParamById("Mtw")) != null) {
            paramList.add("MTW=" + mtw.getList()[(Integer)mtw.getDefaultValue()]);
        }
        if ((tw = (ParamImpl)p.getParamById("Tile Width")) != null) {
            paramList.add("BLOCKXSIZE=" + tw.getList()[(Integer)tw.getDefaultValue()]);
        }
        if ((th = (ParamImpl)p.getParamById("Tile Height")) != null) {
            paramList.add("BLOCKYSIZE=" + th.getList()[(Integer)th.getDefaultValue()]);
        }
        if ((qt = (ParamImpl)p.getParamById("quality")) != null) {
            paramList.add("QUALITY=" + qt.getDefaultValue());
        }
        if ((prog = (ParamImpl)p.getParamById("progressive")) != null) {
            paramList.add("PROGRESSIVE=" + prog.getDefaultValue());
        }
        if (paramList.size() == 0) {
            return null;
        }
        String[] result = new String[paramList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)paramList.get(i);
        }
        return result;
    }

    public void writeByteBand(int sizeY, int posicionY) {
        int iBand;
        byte[][] buftmp = this.dataWriter.readByteData(this.sizeWindowX, sizeY);
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffByte = new byte[buftmp[iBand].length];
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            for (int i = 0; i < buftmp[iBand].length; ++i) {
                this.bufBands[iBand].buffByte[i] = buftmp[iBand][i];
            }
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            try {
                this.rband = this.dstDataset.getRasterBand(iBand + 1);
                this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[iBand], GdalDataset.GDT_Byte);
                this.bufBands[iBand].buffByte = null;
                continue;
            }
            catch (GdalException gdalException) {
                // empty catch block
            }
        }
        buftmp = null;
    }

    public void writeShortBand(int sizeY, int posicionY) {
        int iBand;
        short[][] buftmp = this.dataWriter.readShortData(this.sizeWindowX, sizeY);
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffShort = new short[buftmp[iBand].length];
        }
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            for (int i = 0; i < buftmp[iBand].length; ++i) {
                this.bufBands[iBand].buffShort[i] = buftmp[iBand][i];
            }
        }
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            try {
                this.rband = this.dstDataset.getRasterBand(iBand + 1);
                this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[iBand], GdalDataset.GDT_Int16);
                this.bufBands[iBand].buffShort = null;
                continue;
            }
            catch (GdalException gdalException) {
                // empty catch block
            }
        }
        buftmp = null;
    }

    public void writeIntBand(int sizeY, int posicionY) {
        int iBand;
        int[][] buftmp = this.dataWriter.readIntData(this.sizeWindowX, sizeY);
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffInt = new int[buftmp[iBand].length];
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            for (int i = 0; i < buftmp[iBand].length; ++i) {
                this.bufBands[iBand].buffInt[i] = buftmp[iBand][i];
            }
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            try {
                this.rband = this.dstDataset.getRasterBand(iBand + 1);
                this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[iBand], GdalDataset.GDT_Int32);
                this.bufBands[iBand].buffInt = null;
                continue;
            }
            catch (GdalException gdalException) {
                // empty catch block
            }
        }
        buftmp = null;
    }

    public void writeFloatBand(int sizeY, int posicionY) {
        int iBand;
        float[][] buftmp = this.dataWriter.readFloatData(this.sizeWindowX, sizeY);
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffFloat = new float[buftmp[iBand].length];
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            for (int i = 0; i < buftmp[iBand].length; ++i) {
                this.bufBands[iBand].buffFloat[i] = buftmp[iBand][i];
            }
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            try {
                this.rband = this.dstDataset.getRasterBand(iBand + 1);
                this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[iBand], GdalDataset.GDT_Float32);
                this.bufBands[iBand].buffFloat = null;
                continue;
            }
            catch (GdalException gdalException) {
                // empty catch block
            }
        }
        buftmp = null;
    }

    public void writeDoubleBand(int sizeY, int posicionY) {
        int iBand;
        double[][] buftmp = this.dataWriter.readDoubleData(this.sizeWindowX, sizeY);
        for (iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffDouble = new double[buftmp[iBand].length];
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            for (int i = 0; i < buftmp[iBand].length; ++i) {
                this.bufBands[iBand].buffDouble[i] = buftmp[iBand][i];
            }
        }
        for (iBand = 0; iBand < buftmp.length; ++iBand) {
            try {
                this.rband = this.dstDataset.getRasterBand(iBand + 1);
                this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[iBand], GdalDataset.GDT_Float64);
                this.bufBands[iBand].buffDouble = null;
                continue;
            }
            catch (GdalException gdalException) {
                // empty catch block
            }
        }
        buftmp = null;
    }

    public void writeARGBBand(int sizeY, int posicionY) throws ProcessInterruptedException, OutOfMemoryError {
        int[] buftmp = this.dataWriter.readARGBData(this.sizeWindowX, sizeY, 0);
        for (int iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand].buffByte = new byte[buftmp.length];
        }
        for (int i = 0; i < buftmp.length; ++i) {
            this.bufBands[0].buffByte[i] = (byte)((buftmp[i] & 0xFF0000) >> 16 & 0xFF);
            this.bufBands[1].buffByte[i] = (byte)((buftmp[i] & 0xFF00) >> 8 & 0xFF);
            this.bufBands[2].buffByte[i] = (byte)(buftmp[i] & 0xFF & 0xFF);
        }
        try {
            this.rband = this.dstDataset.getRasterBand(1);
            this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[0], GdalDataset.GDT_Byte);
            this.rband = this.dstDataset.getRasterBand(2);
            this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[1], GdalDataset.GDT_Byte);
            this.rband = this.dstDataset.getRasterBand(3);
            this.rband.writeRaster(0, posicionY, this.sizeWindowX, sizeY, this.bufBands[2], GdalDataset.GDT_Byte);
        }
        catch (GdalException e) {
            e.printStackTrace();
        }
        this.bufBands[0].buffByte = null;
        this.bufBands[1].buffByte = null;
        this.bufBands[2].buffByte = null;
    }

    private void writeBands(int sizeY, int posicionY) throws ProcessInterruptedException, OutOfMemoryError {
        switch (this.dataType) {
            case -1: {
                this.writeARGBBand(sizeY, posicionY);
                break;
            }
            case 0: {
                this.writeByteBand(sizeY, posicionY);
                break;
            }
            case 2: {
                this.writeShortBand(sizeY, posicionY);
                break;
            }
            case 3: {
                this.writeIntBand(sizeY, posicionY);
                break;
            }
            case 4: {
                this.writeFloatBand(sizeY, posicionY);
                break;
            }
            case 5: {
                this.writeDoubleBand(sizeY, posicionY);
            }
        }
    }

    private void write(int mode) throws IOException, ProcessInterruptedException, OutOfMemoryError {
        Buffer source;
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        this.bufBands = new GdalBuffer[this.nBands];
        for (int iBand = 0; iBand < this.nBands; ++iBand) {
            this.bufBands[iBand] = new GdalBuffer();
        }
        int blockSize = RasterLibrary.blockHeight;
        if (this.dataWriter instanceof DefaultDataServerWriter && (source = ((DefaultDataServerWriter)this.dataWriter).getSource()).isCached()) {
            blockSize = source.getBlockHeight();
        }
        this.percent = 0;
        this.nBlocks = this.sizeWindowY / blockSize;
        double increment = (double)(blockSize * 100) / (double)this.sizeWindowY;
        if (mode == 2) {
            for (int iBlock = 0; iBlock < this.nBlocks; ++iBlock) {
                if (task.getEvent() != null) {
                    task.manageEvent(task.getEvent());
                }
                int posicionY = iBlock * blockSize;
                if (this.write) {
                    this.writeBands(blockSize, posicionY);
                }
                this.percent = (int)((double)(iBlock + 1) * increment);
            }
        }
        if (this.anchoResto != 0 && mode == 2) {
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            int posicionY = this.nBlocks * blockSize;
            if (this.write) {
                this.writeBands(this.anchoResto, posicionY);
            }
            this.percent = (int)((double)this.nBlocks * increment);
        }
    }

    public void fileWrite() throws IOException, ProcessInterruptedException {
        this.write(1);
    }

    public static void createCopy(GdalDriver driverDst, String dst, String src, boolean bstrict, String[] params) throws IOException, GdalException {
        if (dst == null || src == null) {
            throw new IOException("No se ha asignado un fichero de entrada.");
        }
        try {
            GdalDataParameters par = new GdalDataParameters();
            par.setFile(new File(src));
            GdalProvider gdalFile = new GdalProvider(par, null);
            GdalDataset dstDataset = driverDst.createCopy(dst, gdalFile.getNative(), bstrict, params);
            if (dst.endsWith(".jpg") || dst.endsWith(".jpeg") || dst.endsWith(".png")) {
                RasterLocator.getManager().getFileUtils().createWorldFile(dst, gdalFile.getExtent(), (int)gdalFile.getWidth(), (int)gdalFile.getHeight());
            }
            gdalFile.close();
            dstDataset.close();
        }
        catch (NotSupportedExtensionException e) {
            e.printStackTrace();
        }
    }

    public void dataWrite() throws IOException, ProcessInterruptedException, OutOfMemoryError {
        if (this.dataWriter == null) {
            throw new IOException("No se ha obtenido un objeto de entrada para la escritura valido.");
        }
        this.write(2);
        if (this.driverParams.getParamById("tfw") != null && ((ParamImpl)this.driverParams.getParamById("tfw")).getDefaultValue() instanceof Boolean && this.at != null) {
            this.fileUtil.createWorldFile(this.outFileName, this.at, this.sizeWindowX, this.sizeWindowY);
        }
        if (this.colorInterp != null) {
            try {
                RasterLocator.getManager().getProviderServices().saveObjectToRmfFile(this.outFileName, DataStoreColorInterpretation.class, (Object)this.colorInterp);
            }
            catch (RmfSerializerException e) {
                throw new IOException("No se ha podido guardar la interpretacion de color");
            }
        }
        this.savePrjFile(new File(this.outFileName), this.proj);
    }

    public void writeClose() {
        try {
            if (this.bufBands != null) {
                for (int i = 0; i < this.bufBands.length; ++i) {
                    this.bufBands[i].buffAPalette = null;
                    this.bufBands[i].buffBPalette = null;
                    this.bufBands[i].buffByte = null;
                    this.bufBands[i].buffShort = null;
                    this.bufBands[i].buffInt = null;
                    this.bufBands[i].buffFloat = null;
                    this.bufBands[i].buffDouble = null;
                }
            }
            if (this.dstDataset != null) {
                this.dstDataset.close();
            }
        }
        catch (GdalException e) {
            e.printStackTrace();
        }
    }

    public void writeCancel() {
        this.write = false;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public void setParams(Params params) {
        if (!(params instanceof ParamsImpl)) {
            return;
        }
        this.driverParams = (ParamsImpl)params;
        int blockSize = 256;
        try {
            ParamImpl param = (ParamImpl)this.driverParams.getParamById("blocksize");
            blockSize = Integer.parseInt(param.getList()[(Integer)param.getDefaultValue()]);
            this.nBlocks = this.sizeWindowY / blockSize;
            this.anchoResto = this.sizeWindowY - this.nBlocks * blockSize;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.drv = null;
        this.dstDataset = null;
        this.rband = null;
        this.geot = null;
        if (this.bufBands != null) {
            for (int i = 0; i < this.bufBands.length; ++i) {
                this.bufBands[i].buffAPalette = null;
                this.bufBands[i].buffBPalette = null;
                this.bufBands[i].buffByte = null;
                this.bufBands[i].buffShort = null;
                this.bufBands[i].buffInt = null;
                this.bufBands[i].buffFloat = null;
                this.bufBands[i].buffDouble = null;
            }
        }
        super.finalize();
    }
}

