/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.util;

import org.cresques.cts.ICRSFactory;
import org.cresques.cts.IProjection;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;

public class DefaultCRSUtils
implements CRSUtils {
    private ICRSFactory factory = null;

    public void setCRSFactory(ICRSFactory factory) {
        this.factory = factory;
    }

    private IProjection getCRS(String code) {
        if (this.factory == null) {
            this.factory = CRSFactory.getCRSFactory();
        }
        return this.factory.get(code);
    }

    public IProjection convertWktToIProjection(String wkt) {
        if (wkt == null || wkt.equals("")) {
            return null;
        }
        String code = null;
        String name = null;
        SpatialReference oSRSSource = new SpatialReference();
        oSRSSource.ImportFromWkt(wkt);
        code = oSRSSource.GetAuthorityCode("PROJCS");
        if (code == null) {
            code = oSRSSource.GetAuthorityCode("GEOGCS");
        }
        if ((name = oSRSSource.GetAuthorityName("PROJCS")) == null) {
            name = oSRSSource.GetAuthorityName("GEOGCS");
        }
        try {
            if (name != null && code != null) {
                return this.getCRS(name + ":" + code);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return null;
    }

    public String convertIProjectionToWkt(IProjection projection) {
        if (projection == null) {
            return null;
        }
        return projection.export("wkt");
    }
}

