/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.memory.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.memory.io.MemoryDataParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.TaskStatus;

public class MemoryRasterProvider
extends AbstractRasterProvider {
    public static String NAME = "Gdal Store";
    public static String DESCRIPTION = "Gdal Raster file";
    public static final String METADATA_DEFINITION_NAME = "GdalStore";
    private Extent v = null;
    protected Buffer buffer = null;
    private Extent extent = null;
    private boolean open = false;

    public static void register() {
    }

    public void registerTileProviderFormats(Class<RasterProvider> c) {
    }

    public MemoryRasterProvider() {
    }

    public MemoryRasterProvider(AbstractRasterDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        super(params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition(METADATA_DEFINITION_NAME)));
        this.setParam(storeServices, (DataStoreParameters)params);
        if (!(params instanceof MemoryDataParameters)) {
            throw new NotSupportedExtensionException("Buffer not supported");
        }
        this.extent = ((MemoryDataParameters)params).getExtent();
        this.buffer = ((MemoryDataParameters)params).getBuffer();
        if (this.extent != null) {
            double psX = (this.extent.maxX() - this.extent.minX()) / (double)this.buffer.getWidth();
            double psY = (this.extent.minY() - this.extent.maxY()) / (double)this.buffer.getHeight();
            this.ownTransformation = new AffineTransform(psX, 0.0, 0.0, psY, this.extent.minX(), this.extent.maxY());
        } else {
            this.ownTransformation = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.buffer.getHeight());
        }
        if (this.buffer == null) {
            throw new NotSupportedExtensionException("Buffer invalid");
        }
        this.load();
        this.bandCount = this.buffer.getBandCount();
        int[] dt = new int[this.buffer.getBandCount()];
        for (int i = 0; i < dt.length; ++i) {
            dt[i] = this.buffer.getDataType();
        }
        this.setDataType(dt);
        this.open = true;
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.buffer = null;
        this.open = false;
    }

    public void setView(Extent e) {
        this.v = e;
    }

    public Extent getView() {
        return this.v;
    }

    public double getWidth() {
        return this.buffer.getWidth();
    }

    public double getHeight() {
        return this.buffer.getHeight();
    }

    public void reProject(ICoordTrans rp) {
    }

    public Object getData(int x, int y, int band) {
        if (this.buffer.getDataType() == 0) {
            return new Integer(this.buffer.getElemByte(y, x, band));
        }
        if (this.buffer.getDataType() == 2) {
            return new Integer(this.buffer.getElemShort(y, x, band));
        }
        if (this.buffer.getDataType() == 3) {
            return new Integer(this.buffer.getElemInt(y, x, band));
        }
        if (this.buffer.getDataType() == 4) {
            return new Float(this.buffer.getElemFloat(y, x, band));
        }
        if (this.buffer.getDataType() == 5) {
            return new Double(this.buffer.getElemDouble(y, x, band));
        }
        return null;
    }

    public int getBlockSize() {
        return 0;
    }

    public boolean isGeoreferenced() {
        return this.extent != null;
    }

    public boolean isSupersampling() {
        return false;
    }

    public int[] getDataType() {
        int[] dt = new int[this.buffer.getBandCount()];
        for (int i = 0; i < dt.length; ++i) {
            dt[i] = this.buffer.getDataType();
        }
        return dt;
    }

    private void adjustPointsToBufferLimits(Point2D begin, Point2D end) {
        if (begin.getX() < 0.0) {
            begin.setLocation(0.0, begin.getY());
        }
        if (begin.getY() > (double)this.buffer.getHeight()) {
            begin.setLocation(begin.getX(), this.buffer.getHeight());
        }
        if (end.getY() < 0.0) {
            end.setLocation(begin.getX(), 0.0);
        }
        if (end.getX() > (double)this.buffer.getWidth()) {
            begin.setLocation(this.buffer.getWidth(), begin.getY());
        }
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        this.getWindow(q.getAdjustedRequestBoundingBox(), q.getBandList(), q.getBufferForProviders(), q.getTaskStatus());
    }

    public Buffer getWindow(Extent ex, BandList bandList, Buffer rasterBuf, TaskStatus status) {
        Point2D begin = this.worldToRaster(new Point2D.Double(ex.getULX(), ex.getULY()));
        Point2D end = this.worldToRaster(new Point2D.Double(ex.getLRX(), ex.getLRY()));
        this.setView(ex);
        this.adjustPointsToBufferLimits(begin, end);
        switch (this.buffer.getDataType()) {
            case 0: {
                this.writeByteBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 2: {
                this.writeShortBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 3: {
                this.writeIntBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 4: {
                this.writeFloatBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 5: {
                this.writeDoubleBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
            }
        }
        return rasterBuf;
    }

    public Buffer getWindow(double x, double y, double w, double h, BandList bandList, Buffer rasterBuf, boolean adjustToExtent, TaskStatus status) {
        Point2D begin = this.worldToRaster(new Point2D.Double(x, y));
        Point2D end = this.worldToRaster(new Point2D.Double(x + w, y - h));
        this.setView((Extent)new ExtentImpl(x, y, x + w, y - h));
        this.adjustPointsToBufferLimits(begin, end);
        switch (this.buffer.getDataType()) {
            case 0: {
                this.writeByteBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 2: {
                this.writeShortBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 3: {
                this.writeIntBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 4: {
                this.writeFloatBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
                break;
            }
            case 5: {
                this.writeDoubleBuffer(rasterBuf, 1.0, 1.0, begin, bandList);
            }
        }
        return rasterBuf;
    }

    public Buffer getWindow(Extent extent, int bufWidth, int bufHeight, BandList bandList, Buffer rasterBuf, boolean adjustToExtent, TaskStatus status) {
        Point2D begin = this.worldToRaster(new Point2D.Double(extent.getMin().getX(), extent.getMax().getY()));
        Point2D end = this.worldToRaster(new Point2D.Double(extent.getMax().getX(), extent.getMin().getY()));
        this.setView(extent);
        this.adjustPointsToBufferLimits(begin, end);
        double w = Math.abs(end.getX() - begin.getX());
        double h = Math.abs(end.getY() - begin.getY());
        double stepX = w / (double)bufWidth;
        double stepY = h / (double)bufHeight;
        switch (this.buffer.getDataType()) {
            case 0: {
                this.writeByteBuffer(rasterBuf, stepX, stepY, begin, bandList);
                break;
            }
            case 2: {
                this.writeShortBuffer(rasterBuf, stepX, stepY, begin, bandList);
                break;
            }
            case 3: {
                this.writeIntBuffer(rasterBuf, stepX, stepY, begin, bandList);
                break;
            }
            case 4: {
                this.writeFloatBuffer(rasterBuf, stepX, stepY, begin, bandList);
                break;
            }
            case 5: {
                this.writeDoubleBuffer(rasterBuf, stepX, stepY, begin, bandList);
            }
        }
        return rasterBuf;
    }

    private void writeByteBuffer(Buffer rasterBuf, double stepX, double stepY, Point2D begin, BandList bandList) {
        int xPx = 0;
        int yPx = 0;
        for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            for (int drawBands = 0; drawBands < drawableBands.length; ++drawBands) {
                yPx = 0;
                for (double row = begin.getY(); yPx < rasterBuf.getHeight() && row < (double)this.buffer.getHeight(); ++yPx, row += stepY) {
                    xPx = 0;
                    for (double col = begin.getX(); xPx < rasterBuf.getWidth() && col < (double)this.buffer.getWidth(); ++xPx, col += stepX) {
                        rasterBuf.setElem(yPx, xPx, iBand, this.buffer.getElemByte((int)row, (int)col, iBand));
                    }
                }
            }
        }
    }

    private void writeShortBuffer(Buffer rasterBuf, double stepX, double stepY, Point2D begin, BandList bandList) {
        int xPx = 0;
        int yPx = 0;
        for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            for (int drawBands = 0; drawBands < drawableBands.length; ++drawBands) {
                yPx = 0;
                double row = begin.getY();
                while (yPx < rasterBuf.getHeight()) {
                    xPx = 0;
                    double col = begin.getX();
                    while (xPx < rasterBuf.getWidth()) {
                        rasterBuf.setElem(yPx, xPx, iBand, this.buffer.getElemShort((int)row, (int)col, iBand));
                        ++xPx;
                        col += stepX;
                    }
                    ++yPx;
                    row += stepY;
                }
            }
        }
    }

    private void writeIntBuffer(Buffer rasterBuf, double stepX, double stepY, Point2D begin, BandList bandList) {
        int xPx = 0;
        int yPx = 0;
        for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            for (int drawBands = 0; drawBands < drawableBands.length; ++drawBands) {
                yPx = 0;
                double row = begin.getY();
                while (yPx < rasterBuf.getHeight()) {
                    xPx = 0;
                    double col = begin.getX();
                    while (xPx < rasterBuf.getWidth()) {
                        rasterBuf.setElem(yPx, xPx, iBand, this.buffer.getElemInt((int)row, (int)col, iBand));
                        ++xPx;
                        col += stepX;
                    }
                    ++yPx;
                    row += stepY;
                }
            }
        }
    }

    private void writeFloatBuffer(Buffer rasterBuf, double stepX, double stepY, Point2D begin, BandList bandList) {
        int xPx = 0;
        int yPx = 0;
        for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            for (int drawBands = 0; drawBands < drawableBands.length; ++drawBands) {
                yPx = 0;
                double row = begin.getY();
                while (yPx < rasterBuf.getHeight()) {
                    xPx = 0;
                    double col = begin.getX();
                    while (xPx < rasterBuf.getWidth()) {
                        rasterBuf.setElem(yPx, xPx, iBand, this.buffer.getElemFloat((int)row, (int)col, iBand));
                        ++xPx;
                        col += stepX;
                    }
                    ++yPx;
                    row += stepY;
                }
            }
        }
    }

    private void writeDoubleBuffer(Buffer rasterBuf, double stepX, double stepY, Point2D begin, BandList bandList) {
        int xPx = 0;
        int yPx = 0;
        for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            for (int drawBands = 0; drawBands < drawableBands.length; ++drawBands) {
                yPx = 0;
                double row = begin.getY();
                while (yPx < rasterBuf.getHeight()) {
                    xPx = 0;
                    double col = begin.getX();
                    while (xPx < rasterBuf.getWidth()) {
                        rasterBuf.setElem(yPx, xPx, iBand, this.buffer.getElemDouble((int)row, (int)col, iBand));
                        ++xPx;
                        col += stepX;
                    }
                    ++yPx;
                    row += stepY;
                }
            }
        }
    }

    public Buffer getWindow(int x, int y, int w, int h, BandList bandList, Buffer rasterBuf, TaskStatus status) {
        this.setView((Extent)new ExtentImpl(this.rasterUtil.getMapRectFromPxRect(this.getExtent().toRectangle2D(), this.getWidth(), this.getHeight(), (Rectangle2D)new Rectangle2D.Double(x, y, w, h))));
        double stepX = (double)w / (double)rasterBuf.getWidth();
        double stepY = (double)h / (double)rasterBuf.getHeight();
        switch (this.buffer.getDataType()) {
            case 0: {
                this.writeByteBuffer(rasterBuf, stepX, stepY, new Point2D.Double(x, y), bandList);
                break;
            }
            case 2: {
                this.writeShortBuffer(rasterBuf, stepX, stepY, new Point2D.Double(x, y), bandList);
                break;
            }
            case 3: {
                this.writeIntBuffer(rasterBuf, stepX, stepY, new Point2D.Double(x, y), bandList);
                break;
            }
            case 4: {
                this.writeFloatBuffer(rasterBuf, stepX, stepY, new Point2D.Double(x, y), bandList);
                break;
            }
            case 5: {
                this.writeDoubleBuffer(rasterBuf, stepX, stepY, new Point2D.Double(x, y), bandList);
            }
        }
        return rasterBuf;
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        switch (this.buffer.getDataType()) {
            case 0: {
                return this.buffer.getLineFromBandByte(line, band);
            }
            case 2: {
                return this.buffer.getLineFromBandShort(line, band);
            }
            case 3: {
                return this.buffer.getLineFromBandInt(line, band);
            }
            case 4: {
                return this.buffer.getLineFromBandFloat(line, band);
            }
            case 5: {
                return this.buffer.getLineFromBandDouble(line, band);
            }
        }
        return null;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if (pos < 0) {
            throw new InvalidSetViewException("Request out of grid");
        }
        if (pos + blockHeight > this.buffer.getHeight()) {
            blockHeight = Math.abs(this.buffer.getHeight() - pos);
        }
        switch (this.buffer.getDataType()) {
            case 0: {
                byte[][][] bufb = new byte[this.getBandCount()][][];
                for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                    for (int row = 0; row < blockHeight; ++row) {
                        bufb[iBand][row] = this.buffer.getLineFromBandByte(row, iBand);
                    }
                }
                return bufb;
            }
            case 2: {
                short[][][] bufs = new short[this.getBandCount()][][];
                for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                    for (int row = 0; row < blockHeight; ++row) {
                        bufs[iBand][row] = this.buffer.getLineFromBandShort(row, iBand);
                    }
                }
                return bufs;
            }
            case 3: {
                int[][][] bufi = new int[this.getBandCount()][][];
                for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                    for (int row = 0; row < blockHeight; ++row) {
                        bufi[iBand][row] = this.buffer.getLineFromBandInt(row, iBand);
                    }
                }
                return bufi;
            }
            case 4: {
                float[][][] buff = new float[this.getBandCount()][][];
                for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                    for (int row = 0; row < blockHeight; ++row) {
                        buff[iBand][row] = this.buffer.getLineFromBandFloat(row, iBand);
                    }
                }
                return buff;
            }
            case 5: {
                double[][][] bufd = new double[this.getBandCount()][][];
                for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                    for (int row = 0; row < blockHeight; ++row) {
                        bufd[iBand][row] = this.buffer.getLineFromBandDouble(row, iBand);
                    }
                }
                return bufd;
            }
        }
        return null;
    }

    public Transparency getTransparency() {
        if (this.transparency == null) {
            this.transparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.transparency;
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public String getName() {
        return "buffer" + ((Object)((Object)this)).hashCode();
    }

    public String getFullName() {
        return this.getName();
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof MemoryRasterProvider) {
            // empty if block
        }
    }

    public TileServer getTileServer() {
        return null;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

