/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.mapcontext.raster.swing.SelectableBandDescriptorsTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class DefaultSelectableBandDescriptorsTableModel
extends AbstractTableModel
implements SelectableBandDescriptorsTableModel {
    private static final long serialVersionUID = -3653794540611142562L;
    private List<SelectableBand> bands = new ArrayList<SelectableBand>();
    private static final int COLUMNS = 5;
    private static final int COLUMN_SELECTED = 0;
    private static final int COLUMN_NUMBER = 1;
    private static final int COLUMN_BAND_STORE_NAME = 2;
    private static final int COLUMN_BAND_NUMBER_IN_STORE = 3;
    private static final int COLUMN_BAND_NAME = 4;

    public DefaultSelectableBandDescriptorsTableModel(List<BandDescriptor> bandDescriptors) {
        for (int i = 0; i < bandDescriptors.size(); ++i) {
            SelectableBand selectableBand = new SelectableBand(i, bandDescriptors.get(i), true);
            this.bands.add(selectableBand);
        }
    }

    @Override
    public int getRowCount() {
        return this.bands.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.bands.get(rowIndex).isSelected();
            }
            case 1: {
                return this.bands.get(rowIndex).getNumber();
            }
            case 2: {
                return this.bands.get(rowIndex).getBandDescriptor().getStore().getName();
            }
            case 3: {
                return this.bands.get(rowIndex).getBandDescriptor().getBand();
            }
            case 4: {
                return this.bands.get(rowIndex).getBandDescriptor().getName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.bands.size() && columnIndex < 5) {
            switch (columnIndex) {
                case 0: {
                    if (aValue == null) {
                        this.bands.get(rowIndex).setSelected(false);
                        break;
                    }
                    if (!(aValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The object '" + aValue.toString() + "' must be a Boolean.");
                    }
                    this.bands.get(rowIndex).setSelected((Boolean)aValue);
                    this.fireTableDataChanged();
                    break;
                }
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_selected");
            }
            case 1: {
                return i18nManager.getTranslation("_number");
            }
            case 2: {
                return i18nManager.getTranslation("_store_name");
            }
            case 3: {
                return i18nManager.getTranslation("_band_number");
            }
            case 4: {
                return i18nManager.getTranslation("_band_name");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return Boolean.class;
        }
        return super.getColumnClass(col);
    }

    public void up(int rowIndex) {
        if (rowIndex > 0) {
            SelectableBand aux = this.bands.get(rowIndex);
            this.bands.set(rowIndex, this.bands.get(rowIndex - 1));
            this.bands.set(rowIndex - 1, aux);
            this.fireTableDataChanged();
        }
    }

    public void down(int rowIndex) {
        if (rowIndex < this.bands.size() - 1) {
            SelectableBand aux = this.bands.get(rowIndex);
            this.bands.set(rowIndex, this.bands.get(rowIndex + 1));
            this.bands.set(rowIndex + 1, aux);
            this.fireTableDataChanged();
        }
    }

    public List<Integer> getSelectedBands() {
        ArrayList<Integer> selectedBands = new ArrayList<Integer>();
        for (SelectableBand selBand : this.bands) {
            if (!selBand.isSelected()) continue;
            selectedBands.add(selBand.getNumber());
        }
        return Collections.unmodifiableList(selectedBands);
    }

    public void selectBand(int band) {
        this.bands.get(band).setSelected(true);
        this.fireTableDataChanged();
    }

    public void unselectBand(int band) {
        this.bands.get(band).setSelected(false);
        this.fireTableDataChanged();
    }

    public void selectAllBands() {
        for (SelectableBand selBand : this.bands) {
            selBand.setSelected(true);
            this.fireTableDataChanged();
        }
    }

    public void unselectAllBands() {
        for (SelectableBand selBand : this.bands) {
            selBand.setSelected(false);
            this.fireTableDataChanged();
        }
    }

    public static class SelectableBand {
        private boolean selected;
        private int number;
        private BandDescriptor bandDescriptor;

        public SelectableBand(int number, BandDescriptor bandDescriptor, boolean selected) {
            this.setNumber(number);
            this.setBandDescriptor(bandDescriptor);
            this.setSelected(selected);
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public BandDescriptor getBandDescriptor() {
            return this.bandDescriptor;
        }

        public void setBandDescriptor(BandDescriptor bandDescriptor) {
            this.bandDescriptor = bandDescriptor;
        }
    }
}

