/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.export;

import java.io.File;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.raster.NewRasterStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.mapcontext.raster.swing.export.ExportRasterPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportRasterPanel
implements ExportRasterPanel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExportRasterPanel.class);
    JFileChooser jfc;
    Buffer buffer;

    public JComponent asJComponent() {
        return this.jfc;
    }

    public void set(Buffer buffer) {
        this.buffer = buffer;
        this.init();
    }

    private void init() {
        DataManager dm = DALLocator.getDataManager();
        FilesystemServerExplorer explorer = null;
        try {
            FilesystemServerExplorerParameters param = (FilesystemServerExplorerParameters)dm.createServerExplorerParameters("FilesystemExplorer");
            explorer = (FilesystemServerExplorer)dm.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JFileChooser jfc = new JFileChooser("/home/paco/tmp");
        List dataStoreProviderNames = explorer.getDataStoreProviderNames();
        ArrayList<FilesystemServerExplorerProvider> creationProviders = new ArrayList<FilesystemServerExplorerProvider>();
        Iterator filters = explorer.getFilters(4);
        while (filters.hasNext()) {
            FilesystemServerExplorerProvider provider = (FilesystemServerExplorerProvider)filters.next();
            if (!provider.canCreate()) continue;
            creationProviders.add(provider);
            jfc.addChoosableFileFilter(new MyFileFilter((FilesystemFileFilter)provider));
        }
        jfc.setFileSelectionMode(0);
        jfc.setAcceptAllFileFilterUsed(false);
    }

    protected JComponent loadPanelProperties(NewRasterStoreParameters params) {
        return null;
    }

    public static class MyFileFilter
    extends FileFilter {
        private FilesystemFileFilter fileFilter;

        public MyFileFilter(FilesystemFileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.getFileFilter().accept(f);
        }

        @Override
        public String getDescription() {
            return this.getFileFilter().getDescription();
        }

        public FilesystemFileFilter getFileFilter() {
            return this.fileFilter;
        }
    }
}

