/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.operations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gvsig.fmap.mapcontext.raster.swing.impl.operations.OperationEntryNameCellRenderer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.operations.OperationListPanelView;
import org.gvsig.fmap.mapcontext.raster.swing.impl.operations.OperationListTableModel;
import org.gvsig.fmap.mapcontext.raster.swing.operations.OperationListPanel;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationListPanelController
extends OperationListPanelView
implements OperationListPanel {
    private static final long serialVersionUID = 938628147696863910L;
    private static final Logger LOG = LoggerFactory.getLogger(OperationListPanelController.class);

    public OperationListPanelController() {
        this.translate();
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.btnAdd.setActionCommand("add_operation_entry");
        this.btnUpdate.setActionCommand("update_operation_entry");
        this.btnRemove.setActionCommand("remove_operation_entry");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                OperationListTableModel model = (OperationListTableModel)OperationListPanelController.this.tblOperationList.getModel();
                int index = selectedRow = OperationListPanelController.this.tblOperationList.getSelectedRow();
                model.removeElementAt(OperationListPanelController.this.tblOperationList.getSelectedRow());
                if (index >= OperationListPanelController.this.tblOperationList.getRowCount()) {
                    index = OperationListPanelController.this.tblOperationList.getRowCount() - 1;
                }
                if (index >= 0) {
                    OperationListPanelController.this.tblOperationList.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        });
        this.btnUp.setActionCommand("up_operation_entry");
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                OperationListTableModel model = (OperationListTableModel)OperationListPanelController.this.tblOperationList.getModel();
                int index = selectedRow = OperationListPanelController.this.tblOperationList.getSelectedRow();
                if (selectedRow > 0) {
                    --index;
                }
                model.up(selectedRow);
                OperationListPanelController.this.tblOperationList.getSelectionModel().setSelectionInterval(index, index);
            }
        });
        this.btnUp.setActionCommand("down_operation_entry");
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                OperationListTableModel model = (OperationListTableModel)OperationListPanelController.this.tblOperationList.getModel();
                int index = selectedRow = OperationListPanelController.this.tblOperationList.getSelectedRow();
                if (selectedRow < OperationListPanelController.this.tblOperationList.getRowCount()) {
                    ++index;
                }
                model.down(selectedRow);
                OperationListPanelController.this.tblOperationList.getSelectionModel().setSelectionInterval(index, index);
            }
        });
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        this.btnUpdate.setEnabled(false);
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.btnAdd.setIcon(iconTheme.get("add-operation-icon"));
        this.btnRemove.setIcon(iconTheme.get("remove-operation-icon"));
        this.btnUp.setIcon(iconTheme.get("up-operation-icon"));
        this.btnDown.setIcon(iconTheme.get("down-operation-icon"));
        this.btnUpdate.setIcon(iconTheme.get("update-operation-icon"));
        this.tblOperationList.setRowSelectionAllowed(true);
        this.tblOperationList.setColumnSelectionAllowed(false);
        this.tblOperationList.setSelectionMode(0);
        OperationListTableModel model = new OperationListTableModel();
        this.tblOperationList.setModel(model);
        this.tblOperationList.setColumnModel(new DefaultTableColumnModel());
        TableColumnModel columnModel = this.tblOperationList.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(model.getColumnName(i));
            tableColumn.setHeaderValue(model.getColumnName(i));
            columnModel.addColumn(tableColumn);
        }
        columnModel.getColumn(0).setCellRenderer(new OperationEntryNameCellRenderer());
        this.tblOperationList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = OperationListPanelController.this.tblOperationList.getSelectedRow();
                OperationListPanelController.this.btnUp.setEnabled(selectedRow >= 0);
                OperationListPanelController.this.btnDown.setEnabled(selectedRow >= 0);
                OperationListPanelController.this.btnUpdate.setEnabled(selectedRow >= 0);
                OperationListPanelController.this.btnRemove.setEnabled(selectedRow >= 0);
            }
        });
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnAdd.setText("");
        this.btnAdd.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
        this.btnRemove.setText("");
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
        this.btnUp.setText("");
        this.btnUp.setToolTipText(i18nManager.getTranslation(this.btnUp.getToolTipText()));
        this.btnDown.setText("");
        this.btnDown.setToolTipText(i18nManager.getTranslation(this.btnDown.getToolTipText()));
        this.btnUpdate.setText("");
        this.btnUpdate.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public void set(OperationList operationList) {
        this.addOperations(operationList);
    }

    private void addOperations(OperationList operationList) {
        OperationListTableModel model = (OperationListTableModel)this.tblOperationList.getModel();
        for (OperationListEntry operationListEntry : operationList) {
            try {
                model.add((OperationListEntry)operationListEntry.clone());
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("Can't clone operation list entry", (Throwable)e);
            }
            model.fireTableDataChanged();
        }
    }

    public boolean fetch(OperationList operationList) {
        OperationListTableModel model = (OperationListTableModel)this.tblOperationList.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            OperationListEntry entry = model.getElementAt(i);
            try {
                operationList.add((Object)((OperationListEntry)entry.clone()));
                continue;
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("Can't get the operation list.");
                return false;
            }
        }
        return true;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.tblOperationList.getSelectionModel().addListSelectionListener(listener);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tblOperationList.getModel().addTableModelListener(listener);
    }

    public OperationListEntry getSelected() {
        int selectedRow = this.tblOperationList.getSelectedRow();
        OperationListTableModel model = (OperationListTableModel)this.tblOperationList.getModel();
        if (selectedRow >= 0 && selectedRow < model.getRowCount()) {
            return model.getElementAt(selectedRow);
        }
        return null;
    }

    public void enableAdd(boolean enable) {
        this.btnAdd.setEnabled(enable);
    }

    public void enableUpdate(boolean enable) {
        this.btnUpdate.setEnabled(enable);
    }

    public void add(OperationListEntry operationListEntry) {
        OperationListTableModel operationListTableModel = (OperationListTableModel)this.tblOperationList.getModel();
        operationListTableModel.add(operationListEntry);
        this.tblOperationList.getSelectionModel().setSelectionInterval(this.tblOperationList.getRowCount() - 1, this.tblOperationList.getRowCount() - 1);
    }

    public void addActionListener(ActionListener listener) {
        this.btnAdd.addActionListener(listener);
        this.btnUpdate.addActionListener(listener);
        this.btnUp.addActionListener(listener);
        this.btnDown.addActionListener(listener);
        this.btnRemove.addActionListener(listener);
    }

    public void clearSelection() {
        this.tblOperationList.clearSelection();
    }

    public void select(int row) {
        this.tblOperationList.getSelectionModel().setSelectionInterval(row, row);
    }

    public int getSelectedRow() {
        return this.tblOperationList.getSelectedRow();
    }
}

