/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.NullGeometry;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.dissolve.AdjacencyDissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.Summary;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class AtomicDissolveOperation
extends GeometryOperation {
    private IDissolveRule rule = null;
    private ArrayList<Geometry> geometryList = null;
    private ArrayList<Feature> featList = null;
    private Feature feature = null;
    private EditableFeature result = null;
    private FeatureStore outFeatureStore = null;
    private int newFeatID = 0;
    private Summary summary = null;

    public AtomicDissolveOperation(AbstractSextanteGeoProcess p) {
        super(p);
    }

    public void setCriteria(IDissolveRule rule) {
        this.rule = rule;
    }

    public void setGeometryList(ArrayList<Geometry> geoList) {
        this.geometryList = geoList;
    }

    public void setFeatureList(ArrayList<Feature> featList) {
        this.featList = featList;
    }

    public void setFeature(Feature feat) {
        this.feature = feat;
    }

    public void setFeatureStore(FeatureStore out, String[] attrNames) {
        this.outFeatureStore = out;
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        Geometry g1 = this.geometryList.get(0);
        if (g1 == null || g instanceof NullGeometry) {
            return null;
        }
        Geometry g2 = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        if (g1 == null || g1.compareTo((Object)g2) == 0) {
            return null;
        }
        if (this.rule.verifyIfDissolve(g1, g2, this.feature, feature)) {
            this.geometryList.add(g2);
            Geometry newGeom = GeometryUtil.geometryUnion(this.geometryList, (int)g.getGeometryType().getType());
            try {
                this.result = this.outFeatureStore.createNewFeature();
                this.result.setDouble(0, (double)this.newFeatID);
                this.result.set(1, feature.get(this.rule.getFieldName()));
                this.summary.updateValues(feature);
                this.summary.loadEditableFeature(this.result);
                this.result.setGeometry("GEOMETRY", GeometryUtil.jtsToGeom((Geometry)newGeom));
                this.geometryList.clear();
                this.geometryList.add(newGeom);
                return this.result;
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return null;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
    }

    public Object getResult() {
        ++this.newFeatID;
        return this.result;
    }

    public void computesOperation(boolean selectedGeom) throws DataException {
        this.result = null;
        this.summary = new Summary(this.rule, this.outFeatureStore.getDefaultFeatureType());
        this.summary.loadDefaultSummarizes(this.feature);
        for (int i = this.featList.size() - 1; i >= 0; --i) {
            if (this.process.getTaskMonitor().isCanceled()) {
                return;
            }
            Feature feature = this.featList.get(i);
            org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
            EditableFeature ef = this.invoke(geom, feature);
            if (ef == null) continue;
            this.featList.remove(i);
            if (this.process != null) {
                this.process.setProgress(this.numberOfFeatures - this.featList.size(), this.numberOfFeatures);
            }
            if (!(this.rule instanceof AdjacencyDissolveRule)) continue;
            i = this.featList.size();
        }
        if (this.result == null) {
            try {
                Geometry newGeom = GeometryUtil.geometryUnion(this.geometryList, (int)this.feature.getDefaultGeometry().getGeometryType().getType());
                this.result = this.outFeatureStore.createNewFeature();
                this.result.setDouble(0, (double)this.newFeatID);
                this.result.set(1, this.feature.get(this.rule.getFieldName()));
                this.summary.updateValues(this.feature);
                this.summary.loadEditableFeature(this.result);
                this.result.setGeometry("GEOMETRY", GeometryUtil.jtsToGeom((Geometry)newGeom));
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }
}

