/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.NullGeometry;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.dissolve.AtomicDissolveOperation;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.DisposableIterator;

public class DissolveOperation
extends GeometryOperation {
    private EditableFeature lastEditFeature = null;
    private ArrayList<Geometry> geometries = new ArrayList();
    private IDissolveRule criteria = null;
    private AtomicDissolveOperation atomicOperation = null;

    public DissolveOperation(IDissolveRule criteria, AbstractSextanteGeoProcess p) {
        super(p);
        this.criteria = criteria;
    }

    public AtomicDissolveOperation getAtomicDissolveOperation() {
        if (this.atomicOperation == null) {
            this.atomicOperation = new AtomicDissolveOperation(this.process);
        }
        return this.atomicOperation;
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        if (g == null) {
            return this.lastEditFeature;
        }
        this.getAtomicDissolveOperation().setFeature(feature);
        try {
            this.getAtomicDissolveOperation().computesOperation(this.selectedGeomInput);
            EditableFeature res = (EditableFeature)this.getAtomicDissolveOperation().getResult();
            this.lastEditFeature = this.persister.addFeature((Feature)res, res.getDefaultGeometry());
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        if (g == null) {
            return;
        }
    }

    public Object getResult() {
        return this.lastEditFeature;
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOutput, boolean closeOutStore) throws DataException {
        this.inFeatureStore = inFeatStore;
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOutput;
        FeatureSet featuresSet = null;
        featuresSet = inFeatStore.getFeatureSet();
        this.setFeatureStore(outFeatStore, attrNames);
        DisposableIterator it = null;
        if (selectedGeomInput) {
            FeatureSelection ds = inFeatStore.getFeatureSelection();
            it = ds.iterator();
            this.numberOfFeatures = (int)ds.getSelectedCount();
        } else {
            it = featuresSet.iterator();
            this.numberOfFeatures = (int)featuresSet.getSize();
        }
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
            this.process.setProgress(0, this.numberOfFeatures);
        }
        ArrayList<Feature> featList = new ArrayList<Feature>();
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            featList.add((Feature)it.next());
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
        }
        this.getAtomicDissolveOperation().setTaskStatus(this.status);
        this.getAtomicDissolveOperation().setGeoProcess(this.process, this.numberOfFeatures);
        this.getAtomicDissolveOperation().setCriteria(this.criteria);
        this.getAtomicDissolveOperation().setGeometryList(this.geometries);
        this.getAtomicDissolveOperation().setFeatureStore(this.persister.getOutputFeatureStore(), null);
        this.getAtomicDissolveOperation().setFeatureList(featList);
        iCount = 0;
        while (featList.size() > 0 && !this.process.getTaskMonitor().isCanceled()) {
            org.gvsig.fmap.geom.Geometry geom;
            Feature feature = featList.remove(0);
            this.geometries.clear();
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)(this.numberOfFeatures - featList.size()));
                this.process.setProgress(this.numberOfFeatures - featList.size(), this.numberOfFeatures);
            }
            if ((geom = feature.getDefaultGeometry()) instanceof NullGeometry) continue;
            this.geometries.add(GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom));
            this.invoke(geom, feature);
        }
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }
}

