/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.processes;

import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesParameters;
import org.gvsig.derivedgeometries.swing.impl.AbstractDerivedGeometriesProcess;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointToLineDerivedGeometriesProcess
extends AbstractDerivedGeometriesProcess {
    private static final Logger logger = LoggerFactory.getLogger(PointToLineDerivedGeometriesProcess.class);

    public PointToLineDerivedGeometriesProcess(DerivedGeometriesParameters parameters) {
        super("Point to line process", parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SimpleTaskStatus status = null;
        try {
            FeatureStore featureStore;
            status = (SimpleTaskStatus)this.getTaskStatus();
            if (status.isCancellationRequested()) {
                status.cancel();
                return;
            }
            DerivedGeometriesParameters parameters = super.getParameters();
            String outputLayerName = parameters.getOutPutLayerName();
            String outputLayerPath = parameters.getOutPutLayerPath();
            int outputLayerType = parameters.getOutPutLayerType();
            boolean addLayer = parameters.getAddLayer();
            boolean createNewFeatureStore = parameters.getCreateNewFeatureStore();
            FLyrVect sourceLayer = parameters.getSourceLayer();
            IProjection projection = sourceLayer.getProjection();
            FeatureType sourceFeatureType = sourceLayer.getFeatureStore().getDefaultFeatureType();
            List selectedFeatures = parameters.getSelectedFeatures();
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            GeometryType sourceGeomType = sourceLayer.getFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
            Line line = geomManager.createLine(sourceGeomType.getSubType());
            Object vertexAnt = null;
            status.setRangeOfValues(1L, (long)selectedFeatures.size());
            for (int i = 0; i < selectedFeatures.size(); ++i) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                status.setCurValue((long)i);
                FeatureReference featureReference = (FeatureReference)selectedFeatures.get(i);
                Geometry geom = featureReference.getFeature().getDefaultGeometry();
                Point point = geom.getType() == 7 && ((MultiPoint)geom).getPrimitivesNumber() == 1 ? ((MultiPoint)geom).getPointAt(0) : (Point)geom;
                if (vertexAnt != null && vertexAnt.equals(point)) continue;
                line.addVertex(point);
                vertexAnt = point;
            }
            if (status.isCancellationRequested()) {
                status.cancel();
                return;
            }
            if (createNewFeatureStore) {
                this.createNewFeatureStore(sourceFeatureType, outputLayerType, outputLayerPath, projection);
                parameters.setCreateNewFeatureStore(false);
            }
            if ((featureStore = parameters.getFeatureStore()) == null) {
                featureStore = this.getFeatureStore(outputLayerPath, projection);
            }
            this.setEditingMode(featureStore);
            this.insertGeometryIntoFeauteStore(featureStore, (Geometry)line);
            this.endEditingMode(featureStore);
            if (status.isCancellationRequested()) {
                status.cancel();
                return;
            }
            if (addLayer) {
                featureStore.dispose();
                featureStore = this.addLayerToMapContex(outputLayerName, outputLayerPath, projection);
                parameters.setAddLayer(false);
                parameters.setFeatureStore(featureStore);
            }
            this.postProcess();
        }
        catch (Exception e) {
            ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            dlgManager.messageDialog("_process_error", "_error", 0);
            logger.info("Error in point to line process", (Throwable)e);
            if (status != null) {
                status.abort();
            }
        }
        finally {
            if (status != null && status.isRunning()) {
                status.terminate();
            }
        }
    }

    private void postProcess() {
        ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
        String message = "_process_finished_successfully";
        String title = "_information";
        dlgManager.messageDialog(message, title, 1);
        this.getParameters().getMapControl().getMapContext().invalidate();
    }
}

