/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop;

import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.amic.desktop.ContainedPanel;
import org.amic.desktop.Desktop;

public class ContainerPane
extends JDesktopPane {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    private Desktop desktop;
    private JInternalFrame frame;
    private JTabbedPane tabPane;
    private JSplitPane splitter;
    private int position;
    private double sizeWanted;

    private ContainerPane() {
    }

    public ContainerPane(Desktop desktop, JSplitPane splitter, int position) {
        this.frame = new JInternalFrame();
        this.frame.setClosable(true);
        this.frame.setMaximizable(false);
        this.frame.setIconifiable(false);
        this.frame.setResizable(false);
        this.frame.setBorder(null);
        this.frame.setFrameIcon(null);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent evt) {
                ContainerPane.this.removeCurrentTab();
            }
        });
        this.add((Component)this.frame, JDesktopPane.DEFAULT_LAYER);
        this.frame.show();
        try {
            this.frame.setMaximum(true);
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
        this.tabPane = new JTabbedPane();
        this.tabPane.setTabPlacement(3);
        this.tabPane.setOpaque(true);
        this.tabPane.addChangeListener(new ContainerPaneListener());
        this.frame.getContentPane().add(this.tabPane);
        this.desktop = desktop;
        this.splitter = splitter;
        this.position = position;
        this.sizeWanted = 0.0;
        splitter.setOneTouchExpandable(false);
        this.checkVisibility();
    }

    public void addPanel(ContainedPanel panel) {
        panel.setFrame(this);
        panel.getJComponent().putClientProperty("c.panel", panel);
        panel.setDesktop(this.desktop);
        this.tabPane.addTab(panel.getTabTitle(), panel.getIcon(), panel.getJComponent(), panel.getTitle());
        panel.willShow();
        this.checkVisibility();
        this.checkSize();
        this.tabPane.setSelectedComponent(panel.getJComponent());
    }

    public void removeCurrentTab() {
        if (this.tabPane.getTabCount() > 0 && this.getContainedPanel(this.tabPane.getSelectedIndex()).canClose()) {
            this.tabPane.removeTabAt(this.tabPane.getSelectedIndex());
            this.refreshFrame();
            this.checkVisibility();
        }
    }

    public boolean closeAllPanels() {
        while (this.tabPane.getTabCount() > 0) {
            if (this.getContainedPanel(this.tabPane.getSelectedIndex()).canClose()) {
                this.tabPane.removeTabAt(this.tabPane.getSelectedIndex());
                this.refreshFrame();
                this.checkVisibility();
                continue;
            }
            return false;
        }
        return true;
    }

    private void checkVisibility() {
        boolean shouldShow;
        boolean bl = shouldShow = this.tabPane.getTabCount() > 0;
        if (shouldShow) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.splitter.setDividerSize(4);
        } else {
            this.setVisible(false);
            this.splitter.setDividerSize(0);
        }
    }

    public ContainedPanel getContainedPanel(int index) {
        try {
            JComponent jc = (JComponent)this.tabPane.getComponentAt(index);
            return (ContainedPanel)jc.getClientProperty("c.panel");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void checkSize() {
        double totalSize = 0.0;
        if (this.tabPane.getTabCount() == 1) {
            if (this.position == 0) {
                this.sizeWanted = this.tabPane.getComponent(0).getPreferredSize().getWidth();
                totalSize = this.desktop.getWidth();
                if (totalSize > this.sizeWanted) {
                    this.splitter.setDividerLocation(1.0 - (totalSize - this.sizeWanted) / totalSize);
                } else {
                    this.splitter.setDividerLocation(0.2);
                }
            } else if (this.position == 1) {
                this.sizeWanted = this.tabPane.getComponent(0).getPreferredSize().getWidth();
                totalSize = this.desktop.getWidth();
                if (totalSize > this.sizeWanted) {
                    this.splitter.setDividerLocation((totalSize - this.sizeWanted) / totalSize);
                } else {
                    this.splitter.setDividerLocation(0.8);
                }
            } else if (this.position == 2) {
                this.sizeWanted = this.tabPane.getComponent(0).getPreferredSize().getHeight();
                totalSize = this.desktop.getHeight();
                if (totalSize > this.sizeWanted) {
                    this.splitter.setDividerLocation((totalSize - this.sizeWanted) / totalSize);
                } else {
                    this.splitter.setDividerLocation(0.8);
                }
            }
        }
    }

    public static ContainerPane placeContainerPane(Desktop desktop, JSplitPane splitter, int position) {
        ContainerPane container = new ContainerPane(desktop, splitter, position);
        if (position == 2) {
            splitter.setBottomComponent(container);
        } else if (position == 1) {
            splitter.setRightComponent(container);
        } else if (position == 0) {
            splitter.setLeftComponent(container);
        }
        return container;
    }

    private void refreshFrame() {
        int index = this.tabPane.getSelectedIndex();
        if (index > -1) {
            this.frame.setFrameIcon(this.getContainedPanel(index).getIcon());
            this.frame.setTitle(this.getContainedPanel(index).getTitle());
            this.getContainedPanel(index).update();
        }
    }

    public class ContainerPaneListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ContainerPane.this.refreshFrame();
        }
    }
}

