/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.amic.desktop.ContainerPane;
import org.amic.desktop.DesktopPane;

public class Desktop
extends JFrame {
    private ContainerPane leftContainer;
    private ContainerPane bottomContainer;
    private DesktopPane mainContainer;
    private JSplitPane splitterBottom;
    private JSplitPane splitterLeft;
    private Hashtable toolBars;
    protected Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();

    public Desktop() {
        try {
            this.splitterLeft = new JSplitPane();
            this.splitterBottom = new JSplitPane();
            this.splitterLeft.setResizeWeight(0.0);
            this.splitterBottom.setResizeWeight(1.0);
            this.splitterBottom.setOrientation(0);
            this.getContentPane().add((Component)this.splitterBottom, "Center");
            this.splitterBottom.add((Component)this.splitterLeft, "top");
            this.bottomContainer = ContainerPane.placeContainerPane(this, this.splitterBottom, 2);
            this.leftContainer = ContainerPane.placeContainerPane(this, this.splitterLeft, 0);
            this.mainContainer = DesktopPane.placeDesktopPane(this, this.splitterLeft, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void maximize() {
        this.setBounds((int)(this.screen.getWidth() * 0.05), (int)(this.screen.getHeight() * 0.05), (int)(this.screen.getWidth() * 0.8), (int)(this.screen.getHeight() * 0.75));
        this.setVisible(true);
        this.setExtendedState(6);
        this.validate();
    }

    public void createToolBar(String name, String position) {
        JToolBar toolBar = new JToolBar(name);
        toolBar.setRollover(true);
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        if (this.toolBars == null) {
            this.toolBars = new Hashtable();
        }
        this.toolBars.put(name, toolBar);
        if (position.equals("West") || position.equals("East")) {
            toolBar.setOrientation(1);
        }
        this.getContentPane().add((Component)toolBar, position);
    }

    public void removeToolBar(String name) {
        JToolBar tb = this.getToolBar(name);
        this.getContentPane().remove(tb);
    }

    public JButton createToolBarButton(AbstractAction action) {
        JButton b = new JButton(action);
        if (b.getIcon() != null) {
            b.setToolTipText(b.getText());
            b.setText(null);
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    public void addToolBarButton(String name, AbstractAction action) {
        if (action == null) {
            return;
        }
        JToolBar tb = this.getToolBar(name);
        if (tb != null) {
            tb.add(this.createToolBarButton(action));
        }
    }

    public void addToolBarSeparator(String name) {
        JToolBar tb = this.getToolBar(name);
        if (tb != null && tb.getComponentCount() != 0 && !(tb.getComponentAtIndex(tb.getComponentCount() - 1) instanceof JSeparator)) {
            tb.addSeparator();
        }
    }

    public JToolBar getToolBar(String name) {
        if (this.toolBars == null) {
            return null;
        }
        return (JToolBar)this.toolBars.get(name);
    }

    public DesktopPane getMainContainer() {
        return this.mainContainer;
    }

    public ContainerPane getLeftContainer() {
        return this.leftContainer;
    }

    public ContainerPane getBottomContainer() {
        return this.bottomContainer;
    }

    public void showMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 1, null);
    }

    public JComponent getJComponent() {
        return this.splitterBottom;
    }

    public void putGlobalData(String key, Object value) {
        this.getJComponent().putClientProperty(key, value);
    }

    public Object getGlobalData(String key) {
        return this.getJComponent().getClientProperty(key);
    }

    public void addGlobalDataListener(String key, PropertyChangeListener listener) {
        this.getJComponent().addPropertyChangeListener(key, listener);
    }

    public void removeGlobalDataListener(String key, PropertyChangeListener listener) {
        this.getJComponent().removePropertyChangeListener(key, listener);
    }

    public void removeGlobalDataListener(PropertyChangeListener listener) {
        this.getJComponent().removePropertyChangeListener(listener);
    }
}

