/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JWindow;

public class ProcessWindow
extends JWindow {
    public final int LEFT = 0;
    public final int CENTER = 1;
    public final int RIGHT = 2;
    public final int TOP = 0;
    public final int BOTTOM = 2;
    private boolean alwaysOnTop;

    public ProcessWindow() {
        this.createResources();
    }

    public ProcessWindow(Window owner) {
        super(owner);
        this.createResources();
    }

    public void showAtLocation(int horizontal, int vertical) {
        int vertiLoc;
        int horizLoc;
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        Rectangle winDim = this.getBounds();
        switch (horizontal) {
            case 0: {
                horizLoc = 0;
                break;
            }
            case 2: {
                horizLoc = screenDim.width - winDim.width;
                break;
            }
            default: {
                horizLoc = (screenDim.width - winDim.width) / 2;
            }
        }
        switch (vertical) {
            case 0: {
                vertiLoc = 0;
                break;
            }
            case 2: {
                vertiLoc = screenDim.height - winDim.height;
                break;
            }
            default: {
                vertiLoc = (screenDim.height - winDim.height) / 2;
            }
        }
        this.setLocation(horizLoc, vertiLoc);
        this.setVisible(true);
        this.toFront();
    }

    public void setAlwaysOnTop(boolean value) {
        this.alwaysOnTop = value;
    }

    private void createResources() {
        this.alwaysOnTop = true;
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                ProcessWindow.this.repaint();
            }

            public void focusLost(FocusEvent evt) {
                if (ProcessWindow.this.alwaysOnTop) {
                    ProcessWindow.this.toFront();
                }
            }
        });
        this.rootPane.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
    }
}

