/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop.menu;

import java.awt.Dimension;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MenuCreator {
    private JFrame desktop;
    private JMenuBar menuBar;
    private Stack menu;

    public MenuCreator(JFrame desktop) {
        this.desktop = desktop;
        this.menuBar = new JMenuBar();
        this.menuBar.setPreferredSize(new Dimension(0, 16));
        this.menu = new Stack();
    }

    public JMenu addMenu(String caption) {
        this.checkSeparator();
        JMenu item = new JMenu(caption);
        this.menu.push(new CMenu(item));
        return item;
    }

    public JMenu addMenu(Action action) {
        this.checkSeparator();
        JMenu item = new JMenu(action);
        this.menu.push(new CMenu(item));
        return item;
    }

    public JMenuItem addMenuItem(String caption) {
        this.checkSeparator();
        if (this.menu.size() > 0) {
            JMenuItem item = new JMenuItem(caption);
            ((CMenu)this.menu.peek()).menu.add(item);
            return item;
        }
        return null;
    }

    public JMenuItem addMenuItem(Action action) {
        this.checkSeparator();
        if (this.menu.size() > 0) {
            JMenuItem item = new JMenuItem(action);
            ((CMenu)this.menu.peek()).menu.add(item);
            return item;
        }
        return null;
    }

    public void addSeparator() {
        if (this.menu.size() > 0 && ((CMenu)this.menu.peek()).menu.getItemCount() > 0) {
            ((CMenu)this.menu.peek()).wantSeparator = true;
        }
    }

    public void endMenu() {
        JMenu last;
        if (this.menu.size() > 1) {
            JMenu last2 = ((CMenu)this.menu.pop()).menu;
            if (last2.getItemCount() > 0) {
                ((CMenu)this.menu.peek()).menu.add(last2);
            }
        } else if (this.menu.size() == 1 && (last = ((CMenu)this.menu.pop()).menu).getItemCount() > 0) {
            this.menuBar.add(last);
        }
    }

    public void endCreator() {
        if (this.menuBar.getMenuCount() > 0) {
            this.desktop.setJMenuBar(this.menuBar);
            this.desktop.validate();
        }
    }

    private void checkSeparator() {
        if (this.menu.size() > 0 && ((CMenu)this.menu.peek()).wantSeparator) {
            ((CMenu)this.menu.peek()).menu.addSeparator();
            ((CMenu)this.menu.peek()).wantSeparator = false;
        }
    }

    private class CMenu {
        public JMenu menu;
        public boolean wantSeparator;

        CMenu(JMenu menu) {
            this.menu = menu;
            this.wantSeparator = false;
        }
    }
}

