/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop.panes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import org.amic.desktop.DefaultContainedPanel;
import org.amic.properties.JPropertiesTable;
import org.amic.properties.PropertiesTableModel;
import org.amic.swing.FlatBorder;
import org.amic.util.icons.Icons;
import org.amic.util.string.ShowBytes;

public class ResourcePane
extends DefaultContainedPanel {
    private JProgressBar pbt;
    private JProgressBar pbm;
    private JLabel lt;
    private JLabel lm;
    private Timer tim;

    public ResourcePane() {
        this.setIcon(Icons.getIcon(this.getClass(), "/org/amic/images/resources.gif"));
        this.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        this.setLayout(new BoxLayout(this, 1));
        this.pbt = new JProgressBar(0, 100);
        this.pbt.setBorder(new FlatBorder(1));
        this.pbt.setForeground(Color.RED);
        this.pbt.setStringPainted(true);
        this.lt = new JLabel("Total ");
        this.lt.setAlignmentX(0.0f);
        this.pbt.setAlignmentX(0.0f);
        this.add(this.lt);
        this.add(this.pbt);
        this.pbm = new JProgressBar(0, 100);
        this.pbm.setBorder(new FlatBorder(1));
        this.pbm.setForeground(Color.RED);
        this.pbm.setStringPainted(true);
        this.lm = new JLabel("Maximum ");
        this.lm.setAlignmentX(0.0f);
        this.pbm.setAlignmentX(0.0f);
        this.add(this.lm);
        this.add(this.pbm);
        this.add(Box.createRigidArea(new Dimension(0, 4)));
        JButton bgc = new JButton("Garbage collect");
        bgc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Runtime.getRuntime().gc();
            }
        });
        this.add(bgc);
        JPropertiesTable pt = new JPropertiesTable(new PropertiesTableModel(System.getProperties()));
        JScrollPane sp = new JScrollPane(pt);
        sp.setAlignmentX(0.0f);
        this.add(sp);
        TimerListener tl = new TimerListener();
        tl.actionPerformed(null);
        this.tim = new Timer(5000, tl);
        this.tim.start();
    }

    public void update() {
    }

    public String getTitle() {
        return "Resources";
    }

    public boolean canClose() {
        this.tim.stop();
        this.tim = null;
        return super.canClose();
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Runtime rt = Runtime.getRuntime();
            long used = rt.totalMemory() - rt.freeMemory();
            ResourcePane.this.lt.setText("Total " + new ShowBytes(rt.totalMemory()));
            ResourcePane.this.pbt.setValue((int)(100L * used / rt.totalMemory()));
            ResourcePane.this.pbt.setString(new ShowBytes(used).toString());
            ResourcePane.this.lm.setText("Maximum " + new ShowBytes(rt.maxMemory()));
            ResourcePane.this.pbm.setValue((int)(100L * used / rt.maxMemory()));
            ResourcePane.this.pbm.setString(new ShowBytes(used).toString());
        }
    }
}

