/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.amic.util.string.FilePath;
import org.amic.util.zip.Cleaner;
import org.amic.util.zip.DateFileName;

public class Logger {
    private String fileName;
    private Date current;
    private FileWriter fw;
    private int daysStored;
    private boolean opened;

    public Logger(String fileName, int daysStored) {
        this.fileName = fileName;
        this.daysStored = daysStored;
        this.opened = false;
    }

    public Logger write(String string) {
        boolean wasOpen = this.opened;
        this.open();
        try {
            this.fw.write(this.formatString(string));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!wasOpen) {
            this.close();
        }
        return this;
    }

    private String formatString(String string) {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("HH:mm:ss");
        return df.format(new Date()).toString() + " - " + string + "\n";
    }

    private String topString() {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("EEEE, dd/MM/yyyy HH:mm:ss");
        return df.format(new Date()).toString() + "\n---------------------------------------------\n";
    }

    private Logger open() {
        if (this.opened) {
            return this;
        }
        try {
            this.cleanOlderLog();
            File file = new File(new DateFileName("yyyyMMdd").getFileName(this.fileName));
            boolean isNew = file.createNewFile();
            this.fw = new FileWriter(file.getPath(), true);
            if (isNew) {
                this.fw.write(this.topString());
            }
        }
        catch (IOException e) {
            this.opened = false;
            return null;
        }
        this.opened = true;
        return this;
    }

    private void close() {
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.opened = false;
    }

    private void cleanOlderLog() {
        Calendar c = Calendar.getInstance();
        c.add(5, -this.daysStored);
        new Cleaner("yyyyMMdd").goOn(FilePath.removeFile(this.fileName), FilePath.removePath(this.fileName), c.getTime());
    }
}

