/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.string;

import org.amic.util.parser.ParserException;

public class StringEx {
    private String term;
    private String iniTerm;
    private StringBuffer value;

    public StringEx() {
        this("");
    }

    public StringEx(String value) {
        this(new StringBuffer(value));
    }

    public StringEx(StringBuffer value) {
        this.value = value;
        this.term = "";
        this.iniTerm = "";
    }

    public void setValue(String value) {
        this.value = new StringBuffer(value);
    }

    public String getOccurrence() {
        return this.term;
    }

    public String getInitial() {
        return this.iniTerm;
    }

    public int indexOfSQ(String end) throws ParserException {
        return this.indexOfSQ(new String[]{end});
    }

    public int indexOfSQ(String end, int pos) throws ParserException {
        return this.indexOfSQ(new String[]{end}, pos);
    }

    public int indexOfSQ(String end, int pos, boolean skipFirst) throws ParserException {
        return this.indexOfSQ(new String[]{end}, pos, skipFirst);
    }

    public int indexOfSQ(String[] end) throws ParserException {
        return this.indexOfSQ(end, 0, false);
    }

    public int indexOfSQ(String[] end, int pos) throws ParserException {
        return this.indexOfSQ(end, pos, false);
    }

    public int indexOfSQ(String[] end, int pos, boolean skipFirst) throws ParserException {
        int temp;
        int par = 0;
        int len = this.value.length();
        boolean str = false;
        boolean fld = false;
        char ch = '\u0000';
        this.iniTerm = "";
        this.term = "";
        if (temp >= len) {
            return -1;
        }
        for (temp = pos; temp < this.value.length(); ++temp) {
            int i = 0;
            while (i < end.length) {
                if (temp < len - end[i].length() && this.value.substring(temp, temp + end[i].length()).equalsIgnoreCase(end[i]) && par <= 0 && !str && !fld) {
                    if (temp == pos && skipFirst) {
                        this.iniTerm = end[i];
                    } else {
                        this.term = end[i];
                        return temp;
                    }
                }
                ++i;
            }
            ch = this.value.charAt(temp);
            if (ch == '(' || ch == '[') {
                ++par;
                continue;
            }
            if (ch == ')' || ch == ']') {
                --par;
                continue;
            }
            if (ch == '\"') {
                fld = !fld;
                continue;
            }
            if (ch != '\'') continue;
            str = !str;
        }
        if (par > 0 || str || fld) {
            throw new ParserException("Quoted expression not correctly terminated.");
        }
        return -1;
    }

    public int getInitialLimit(char begin, char end, int pos) {
        int closed = 0;
        int temp = pos;
        while (closed >= 0) {
            if (this.value.charAt(temp) == end) {
                ++closed;
            } else if (this.value.charAt(temp) == begin) {
                --closed;
            }
            if (closed < 0 || --temp < 0) break;
        }
        return temp;
    }

    public int getFinalLimit(char begin, char end, int pos) {
        int initiated = 0;
        int temp = pos;
        while (initiated >= 0) {
            if (this.value.charAt(temp) == end) {
                --initiated;
            } else if (this.value.charAt(temp) == begin) {
                ++initiated;
            }
            if (initiated < 0 || ++temp < this.value.length()) continue;
            temp = -1;
            break;
        }
        return temp;
    }
}

