/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.table;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.table.DefaultTableCellRenderer;

public class FormatterRenderer
extends DefaultTableCellRenderer {
    private int type;
    private String pattern;
    private DecimalFormat decfmt;
    private SimpleDateFormat datfmt;

    public FormatterRenderer(String pattern, int type) {
        this.pattern = pattern;
        this.type = type;
        switch (this.getTypeFormatter(type)) {
            case 1: 
            case 2: {
                this.decfmt = new DecimalFormat(pattern);
                break;
            }
            case 4: {
                this.datfmt = new SimpleDateFormat(pattern);
            }
        }
    }

    protected void setValue(Object value) {
        super.setValue(value);
        switch (this.getTypeFormatter(this.type)) {
            case -1: {
                this.setBackground(Color.decode("#cccccc"));
                this.setBorder(new MetalBorders.TableHeaderBorder());
                this.setHorizontalAlignment(0);
                break;
            }
            case 1: 
            case 2: {
                if (value != null && value instanceof Number) {
                    this.setText(this.decfmt.format(value));
                }
                this.setHorizontalAlignment(4);
                break;
            }
            case 4: {
                if (value != null && value instanceof Date) {
                    this.setText(this.datfmt.format(value));
                }
                this.setHorizontalAlignment(2);
                break;
            }
            case 5: {
                this.setBackground(Color.decode("#cccccc"));
            }
        }
    }

    private int getTypeFormatter(int type) {
        switch (type) {
            case -1000: {
                return -1;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 1;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 2;
            }
            case -1: 
            case 1: 
            case 12: {
                return 3;
            }
            case 91: 
            case 92: 
            case 93: {
                return 4;
            }
            case -7: {
                return 5;
            }
        }
        return 0;
    }
}

