/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.event.EventListenerList;
import org.amic.util.url.URLEvent;
import org.amic.util.url.URLListener;
import org.amic.util.url.UrlCompose;

public class URLConnect {
    private long totalCount = 0L;
    private URLEvent urlEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private String url;
    private String methodParam;
    private String methodCall;
    private boolean shouldEncode;
    static /* synthetic */ Class class$org$amic$util$url$URLListener;

    public URLConnect(URL url) {
        this(url.toString());
    }

    public URLConnect(String url) {
        this(url, "");
    }

    public URLConnect(String url, String param) {
        this.url = url;
        this.methodParam = param;
        this.methodCall = "POST";
        this.shouldEncode = true;
    }

    public URLConnect setMethod(String method) {
        this.methodCall = method;
        return this;
    }

    public URLConnect setParams(String param) {
        return this.setParams(param, true);
    }

    public URLConnect setParams(String param, boolean encode) {
        this.shouldEncode = encode;
        this.methodParam = param;
        return this;
    }

    public InputStream getInputStream() {
        String finalUrl = this.url;
        if (this.shouldEncode) {
            this.methodParam = UrlCompose.encodeQueries(this.methodParam);
        }
        try {
            if (this.methodCall.equalsIgnoreCase("GET") && this.methodParam.length() > 0) {
                finalUrl = finalUrl + "?" + this.methodParam;
            }
            URL u = new URL(finalUrl);
            HttpURLConnection uc = (HttpURLConnection)u.openConnection();
            uc.setRequestMethod(this.methodCall);
            uc.setDoInput(true);
            if (!this.methodCall.equalsIgnoreCase("GET") && this.methodParam.length() > 0) {
                uc.setDoOutput(true);
                OutputStreamWriter osw = new OutputStreamWriter(uc.getOutputStream());
                osw.write(this.methodParam);
                osw.close();
            }
            return uc.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getContent() {
        StringBuffer sb = new StringBuffer(1024);
        try {
            String s;
            BufferedReader rd = new BufferedReader(new InputStreamReader(this.getInputStream()));
            this.totalCount = 0L;
            while ((s = rd.readLine()) != null) {
                void var3_4;
                sb.append((String)var3_4);
                this.totalCount += (long)var3_4.length();
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return sb.toString();
    }

    public boolean toFile(String file) {
        return this.toFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean toFile(File file) {
        byte[] data = new byte[4096];
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                int byteCount;
                InputStream is = this.getInputStream();
                this.totalCount = 0L;
                while ((byteCount = is.read(data, 0, 4096)) > -1) {
                    void var5_6;
                    os.write(data, 0, (int)var5_6);
                    this.totalCount += (long)var5_6;
                }
                os.flush();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                os.close();
                throw throwable;
            }
            os.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void addURLListener(URLListener l) {
        this.listenerList.add(class$org$amic$util$url$URLListener == null ? (class$org$amic$util$url$URLListener = URLConnect.class$("org.amic.util.url.URLListener")) : class$org$amic$util$url$URLListener, l);
    }

    public void removeURLListener(URLListener l) {
        this.listenerList.remove(class$org$amic$util$url$URLListener == null ? (class$org$amic$util$url$URLListener = URLConnect.class$("org.amic.util.url.URLListener")) : class$org$amic$util$url$URLListener, l);
    }

    protected void fireURLDownloading() {
        Object[] listeners = this.listenerList.getListenerList();
        this.urlEvent = new URLEvent(this, this.totalCount);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$org$amic$util$url$URLListener == null ? URLConnect.class$("org.amic.util.url.URLListener") : class$org$amic$util$url$URLListener)) {
                ((URLListener)listeners[i + 1]).downloading(this.urlEvent);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

