/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.amic.util.xml.DBRecord;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;

public class DBTable
implements TablePacked {
    private int visible;
    private String identifier;
    private Vector rows;
    private Vector cols;
    private Vector defaults;
    private Vector formats;
    private Vector valids;
    private boolean shouldInsert;
    private boolean shouldUpdate;
    private boolean shouldDelete;
    private Hashtable properties = null;

    public DBTable() {
        this("table");
    }

    public DBTable(String identifier) {
        this.identifier = identifier;
        this.shouldDelete = true;
        this.shouldInsert = true;
        this.shouldUpdate = true;
        this.cols = new Vector();
        this.rows = new Vector();
        this.defaults = new Vector();
        this.formats = new Vector();
        this.valids = new Vector();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean canInsert() {
        return this.shouldInsert;
    }

    public boolean canUpdate() {
        return this.shouldUpdate;
    }

    public boolean canDelete() {
        return this.shouldDelete;
    }

    public void setCanInsert(boolean value) {
        this.shouldInsert = value;
    }

    public void setCanUpdate(boolean value) {
        this.shouldUpdate = value;
    }

    public void setCanDelete(boolean value) {
        this.shouldDelete = value;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getFieldCount() {
        return this.cols.size();
    }

    public int getIndex(String name) {
        int index = 0;
        while (index < this.getFieldCount()) {
            if (name.equalsIgnoreCase(this.getFieldName(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getVisibleFieldCount() {
        return this.visible == 0 || this.visible > this.cols.size() ? this.cols.size() : this.visible;
    }

    public void setVisibleFieldCount(int value) {
        this.visible = value;
    }

    public String getFieldName(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return "";
        }
        return ((FieldDescription)this.cols.get((int)field)).name;
    }

    public String getFieldLabel(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return "";
        }
        return ((FieldDescription)this.cols.get((int)field)).label;
    }

    public void setFieldLabel(int field, String value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).label = value;
        }
    }

    public int getFieldType(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return -1;
        }
        return ((FieldDescription)this.cols.get((int)field)).type;
    }

    public void setFieldType(int field, int value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).type = value;
        }
    }

    public String getFieldTypeName(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return "";
        }
        return ((FieldDescription)this.cols.get((int)field)).typeName;
    }

    public void setFieldTypeName(int field, String value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).typeName = value;
        }
    }

    public int getFieldDisplaySize(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return 0;
        }
        return ((FieldDescription)this.cols.get((int)field)).displaySize;
    }

    public void setFieldDisplaySize(int field, int value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).displaySize = value;
        }
    }

    public int getFieldPrecision(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return 0;
        }
        return ((FieldDescription)this.cols.get((int)field)).precision;
    }

    public void setFieldPrecision(int field, int value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).precision = value;
        }
    }

    public int getFieldScale(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return 0;
        }
        return ((FieldDescription)this.cols.get((int)field)).scale;
    }

    public void setFieldScale(int field, int value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).scale = value;
        }
    }

    public boolean isFieldCurrency(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return false;
        }
        return ((FieldDescription)this.cols.get((int)field)).isCurrency;
    }

    public void setFieldCurrency(int field, boolean value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).isCurrency = value;
        }
    }

    public boolean isFieldEditable(int field) {
        if (field < 0 || field >= this.cols.size()) {
            return true;
        }
        return ((FieldDescription)this.cols.get((int)field)).isEditable;
    }

    public void setFieldEditable(int field, boolean value) {
        if (field >= 0 && field < this.cols.size()) {
            ((FieldDescription)this.cols.get((int)field)).isEditable = value;
        }
    }

    public void addField(String name, String label, String typeName, int type, int displaySize, int precision, int scale, boolean isCurrency, boolean isEditable) {
        FieldDescription fd = new FieldDescription();
        fd.name = name;
        fd.label = label;
        fd.typeName = typeName;
        fd.type = type;
        fd.displaySize = displaySize;
        fd.precision = precision;
        fd.scale = scale;
        fd.isCurrency = isCurrency;
        fd.isEditable = isEditable;
        this.cols.add(fd);
        this.defaults.add(null);
        this.formats.add(null);
        this.valids.add(null);
    }

    public RecordPacked getRecord(int row) {
        if (row > this.rows.size() - 1 || row < 0) {
            return null;
        }
        return (RecordPacked)this.rows.get(row);
    }

    public RecordPacked insertRecord(int row) {
        if (row > this.rows.size() - 1) {
            return this.appendRecord();
        }
        if (row < 0) {
            row = 0;
        }
        DBRecord dr = new DBRecord(this);
        this.rows.add(row, dr);
        return dr;
    }

    public RecordPacked appendRecord() {
        DBRecord dr = new DBRecord(this);
        this.rows.add(dr);
        return dr;
    }

    public int getIndexRecord(DBRecord record) {
        return this.rows.indexOf(record);
    }

    public Object getFieldDefaultValue(int field) {
        if (field >= 0 && field < this.cols.size()) {
            return this.defaults.get(field);
        }
        return null;
    }

    public void setFieldDefaultValue(int field, Object value) {
        if (field >= 0 && field < this.cols.size()) {
            this.defaults.set(field, value);
        }
    }

    public Object getFieldFormat(int field) {
        if (field >= 0 && field < this.cols.size()) {
            return this.formats.get(field);
        }
        return null;
    }

    public void setFieldFormat(int field, Object value) {
        if (field >= 0 && field < this.cols.size()) {
            this.formats.set(field, value);
        }
    }

    public Object[] getFieldValids(int field) {
        if (field >= 0 && field < this.cols.size()) {
            return (Object[])this.valids.get(field);
        }
        return null;
    }

    public void setFieldValids(int field, Object[] value) {
        if (field >= 0 && field < this.cols.size()) {
            this.valids.set(field, value);
        }
    }

    public void deleteRecord(int row) {
        if (row > this.rows.size() - 1 || row < 0) {
            return;
        }
        boolean full = false;
        RecordPacked record = this.getRecord(row);
        int i = 0;
        while (i < this.cols.size()) {
            Object value = record.getValue(i);
            if (value != null && value.toString().length() > 0 && !value.equals(this.getFieldDefaultValue(i))) {
                full = true;
            }
            ++i;
        }
        if (full) {
            ((RecordPacked)this.rows.get(row)).setDeleted(true);
            ((RecordPacked)this.rows.get(row)).setUpdated(false);
        } else {
            this.rows.remove(row);
        }
    }

    public void putProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public Enumeration getPropertyKeys() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.keys();
    }

    public boolean hasProperties() {
        return this.properties != null && this.properties.size() > 0;
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public class FieldDescription {
        String name;
        String label;
        String typeName;
        int type;
        int displaySize;
        int precision;
        int scale;
        boolean isCurrency;
        boolean isEditable;
    }
}

