/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.amic.util.string.FindReplace;
import org.amic.util.string.StringToVector;
import org.amic.xml.XmlReader;

public class XmlMapper {
    private Hashtable mapping = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public void readFromBundle(ResourceBundle rb, String prefix) {
        Pattern p = Pattern.compile("_(.+)_");
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            Matcher matcher;
            String temp = keys.nextElement();
            if (!temp.startsWith(prefix + "_") || !(matcher = p.matcher(temp)).find()) continue;
            String name = matcher.group(1);
            try {
                temp = rb.getString(prefix + "_" + name + "_format");
                if (temp != null) {
                    this.addFormat(name, temp);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_label");
                if (temp != null) {
                    this.addLabel(name, temp);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_jClass");
                if (temp != null) {
                    this.addJClass(name, Class.forName(temp));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_editable");
                if (temp != null) {
                    this.addEditable(name, Boolean.getBoolean(temp));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_valids");
                if (temp != null) {
                    this.addValids(name, StringToVector.getVector(temp));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_visible");
                if (temp != null) {
                    this.addVisible(name, Boolean.getBoolean(temp));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                temp = rb.getString(prefix + "_" + name + "_show-children");
                if (temp == null) continue;
                this.addShowChildren(name, Boolean.getBoolean(temp));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void addFormat(String name, String format) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.format = format;
        this.mapping.put(name, xm);
    }

    public void addLabel(String name, String label) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.label = label;
        this.mapping.put(name, xm);
    }

    public void addJClass(String name, Class jClass) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.jClass = jClass;
        this.mapping.put(name, xm);
    }

    public void addEditable(String name, boolean editable) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.editable = editable;
        this.mapping.put(name, xm);
    }

    public void addValids(String name, Vector valids) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.valids = valids;
        this.mapping.put(name, xm);
    }

    public void addVisible(String name, boolean visible) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.visible = visible;
        this.mapping.put(name, xm);
    }

    public void addShowChildren(String name, boolean showChildren) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm == null) {
            xm = new XmlMap();
        }
        xm.showChildren = showChildren;
        this.mapping.put(name, xm);
    }

    public String getFormat(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.format;
        }
        return null;
    }

    public String getLabel(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.label == null ? name : xm.label;
        }
        return name;
    }

    public Class getJClass(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.jClass;
        }
        return class$java$lang$String == null ? (class$java$lang$String = XmlMapper.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean getEditable(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.editable;
        }
        return true;
    }

    public Vector getValids(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.valids;
        }
        return null;
    }

    public boolean getVisible(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.visible;
        }
        return true;
    }

    public boolean getShowChildren(String name) {
        XmlMap xm = (XmlMap)this.mapping.get(name);
        if (xm != null) {
            return xm.showChildren;
        }
        return false;
    }

    public String applyFormat(XmlReader node) {
        return XmlMapper.formatNode(this.getFormat(node.getName()), node, this);
    }

    public static String formatNode(String format, XmlReader node, XmlMapper mapper) {
        String temp;
        if (format == null) {
            return node.getName();
        }
        FindReplace fr = new FindReplace(format);
        while (fr.match("/tag-name/")) {
            fr.replace(node.getName());
        }
        fr.resetStart();
        while (fr.match("/tag-value/")) {
            temp = node.getValue();
            fr.replace(temp == null ? "" : temp);
        }
        fr.resetStart();
        while (fr.match("/([a-zA-Z0-9\\-]+)/")) {
            temp = null;
            if (mapper != null) {
                temp = mapper.getFormat(node.getName() + "." + fr.getString(1));
            }
            if (temp != null) {
                if (temp.indexOf("{0,choice") > -1) {
                    MessageFormat ms = new MessageFormat(temp);
                    temp = ms.format(new Object[]{new Double(node.getAttribute(fr.getString(1)))});
                }
            } else {
                temp = node.getAttribute(fr.getString(1));
            }
            fr.replace(temp == null ? "" : temp);
        }
        return fr.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class XmlMap {
        String format;
        String label;
        Class jClass;
        boolean editable;
        boolean visible;
        boolean showChildren;
        Vector valids;

        XmlMap() {
            this(null, null, class$java$lang$String == null ? (class$java$lang$String = XmlMapper.class$("java.lang.String")) : class$java$lang$String, true, null, true, false);
        }

        XmlMap(String format, String label, Class jClass, boolean editable, Vector valids, boolean visible, boolean showChildren) {
            this.format = format;
            this.label = label;
            this.jClass = jClass;
            this.editable = editable;
            this.valids = valids;
            this.visible = visible;
            this.showChildren = showChildren;
        }

        public void addValid(Object value) {
            if (this.valids == null) {
                this.valids = new Vector();
            }
            this.valids.add(value);
        }

        public Object[] stripBooleanFormat() {
            Object[] obj = new Object[2];
            if (this.format == null) {
                obj[0] = "false";
                obj[1] = "true";
            } else {
                int p = this.format.indexOf(59);
                obj[0] = this.format.substring(0, p);
                obj[1] = this.format.substring(p + 1);
            }
            return obj;
        }
    }
}

