/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlReader;

public class XmlTreeModel
extends DefaultTreeModel {
    private boolean dynamic = false;
    private String[] allowed = null;
    private String[] forbidden = null;

    public XmlTreeModel(XmlReader xreader) {
        this(xreader, -1, null, null);
    }

    public XmlTreeModel(XmlReader xreader, int level, String[] allowed, String[] forbidden) {
        super(new DefaultMutableTreeNode(xreader));
        this.allowed = allowed;
        this.forbidden = forbidden;
        this.processChildren((DefaultMutableTreeNode)this.getRoot(), level);
    }

    public void setDynamic(boolean value) {
        this.dynamic = value;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0 && !this.dynamic;
    }

    public boolean processChildren(DefaultMutableTreeNode node, int level) {
        int i;
        String name;
        if (level == 0) {
            return true;
        }
        boolean doIt = true;
        XmlReader n = (XmlReader)node.getUserObject();
        if (this.allowed != null) {
            name = n.getName();
            doIt = false;
            i = 0;
            while (i < this.allowed.length) {
                if (this.allowed[i].equals(name)) {
                    doIt = true;
                    break;
                }
                ++i;
            }
        }
        if (this.forbidden != null) {
            name = n.getName();
            i = 0;
            while (i < this.forbidden.length) {
                if (this.forbidden[i].equals(name)) {
                    doIt = false;
                    break;
                }
                ++i;
            }
        }
        if (!doIt) {
            return false;
        }
        NodeSet nodes = n.getNodeSet();
        while (nodes.hasNextNode()) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodes.nextNode());
            if (!this.processChildren(newNode, level - 1)) continue;
            node.add(newNode);
        }
        return true;
    }
}

