/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Vector;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import next.swing.AbstractTreeTableModel;
import next.swing.JTreeTable;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlReader;
import org.amic.xml.XmlTreeTableRenderer;

public class XmlTreeTableModel
extends AbstractTreeTableModel {
    private Vector columns = null;
    private String[] allowed = null;
    private String[] forbidden = null;
    private boolean dynamic = false;
    public final int ALIGN_LEFT = 2;
    public final int ALIGN_RIGHT = 4;
    public final int ALIGN_CENTER = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$amic$util$date$Date;
    static /* synthetic */ Class class$next$swing$TreeTableModel;

    public XmlTreeTableModel(XmlReader xreader) {
        this(xreader, -1, null, null);
    }

    public XmlTreeTableModel(XmlReader xreader, int level, String[] allowed, String[] forbidden) {
        super(new DefaultMutableTreeNode(xreader));
        this.allowed = allowed;
        this.forbidden = forbidden;
        this.processChildren((DefaultMutableTreeNode)this.getRoot(), level);
    }

    public void setDynamic(boolean value) {
        this.dynamic = value;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0 && !this.dynamic;
    }

    public boolean processChildren(DefaultMutableTreeNode node, int level) {
        int i;
        String name;
        if (level == 0) {
            return true;
        }
        boolean doIt = true;
        XmlReader n = (XmlReader)node.getUserObject();
        if (this.allowed != null) {
            name = n.getName();
            doIt = false;
            i = 0;
            while (i < this.allowed.length) {
                if (this.allowed[i].equals(name)) {
                    doIt = true;
                    break;
                }
                ++i;
            }
        }
        if (this.forbidden != null) {
            name = n.getName();
            i = 0;
            while (i < this.forbidden.length) {
                if (this.forbidden[i].equals(name)) {
                    doIt = false;
                    break;
                }
                ++i;
            }
        }
        if (!doIt) {
            return false;
        }
        NodeSet nodes = n.getNodeSet();
        while (nodes.hasNextNode()) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodes.nextNode());
            if (!this.processChildren(newNode, level - 1)) continue;
            node.add(newNode);
        }
        return true;
    }

    public void applyDefaults(JTreeTable tt) {
        TableColumnModel tcm = tt.getColumnModel();
        int total = 0;
        int i = 1;
        while (i < tcm.getColumnCount()) {
            Column col = (Column)this.columns.elementAt(i - 1);
            tcm.getColumn(i).setCellRenderer(new XmlTreeTableRenderer(col.format, col.align, col.jClass));
            tcm.getColumn(i).setPreferredWidth(col.width * 10);
            total += col.width;
            ++i;
        }
        tcm.getColumn(0).setPreferredWidth((100 - total) * 10);
    }

    public void addStringColumn(String name, String attribute, String label, int width) {
        this.addColumn(new Column(name, attribute, label, 2, width, class$java$lang$String == null ? (class$java$lang$String = XmlTreeTableModel.class$("java.lang.String")) : class$java$lang$String, null));
    }

    public void addNumberColumn(String name, String attribute, String label, int width, String format) {
        this.addColumn(new Column(name, attribute, label, 4, width, class$java$lang$Double == null ? (class$java$lang$Double = XmlTreeTableModel.class$("java.lang.Double")) : class$java$lang$Double, format));
    }

    public void addDateColumn(String name, String attribute, String label, int width, String format) {
        this.addColumn(new Column(name, attribute, label, 2, width, class$org$amic$util$date$Date == null ? (class$org$amic$util$date$Date = XmlTreeTableModel.class$("org.amic.util.date.Date")) : class$org$amic$util$date$Date, format));
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new Vector();
        }
        this.columns.add(column);
    }

    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public Object getChild(Object parent, int index) {
        return ((DefaultMutableTreeNode)parent).getChildAt(index);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return ((Column)this.columns.elementAt((int)(column - 1))).label;
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return class$next$swing$TreeTableModel == null ? (class$next$swing$TreeTableModel = XmlTreeTableModel.class$("next.swing.TreeTableModel")) : class$next$swing$TreeTableModel;
        }
        return ((Column)this.columns.elementAt((int)(column - 1))).jClass;
    }

    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        if (currentNode.getUserObject() instanceof XmlReader) {
            XmlReader xr = (XmlReader)currentNode.getUserObject();
            if (column == 0) {
                return xr.toString();
            }
            Column col = (Column)this.columns.elementAt(column - 1);
            if (col.name != null && !col.name.equals(xr.getName())) {
                return null;
            }
            String att = col.attribute;
            while (att.startsWith("@") && xr != null) {
                int p = att.indexOf("@", 1);
                if (p == -1) {
                    p = att.indexOf(":", 1);
                }
                xr = xr.getNodeByName(att.substring(1, p));
                att = att.substring(p);
            }
            if (xr == null) {
                return null;
            }
            if (att.startsWith(":")) {
                att = att.substring(1);
            }
            try {
                if (att.equals("tag-name")) {
                    return xr.getName();
                }
                if (att.equals("tag-value")) {
                    return xr.getValue();
                }
                return xr.getAttribute(att);
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 1;
        }
        return this.columns.size() + 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Column {
        int align;
        int width;
        Class jClass;
        String name;
        String attribute;
        String label;
        String format;

        Column(String name, String attribute, String label, int align, int width, Class jClass, String format) {
            this.name = name;
            this.attribute = attribute;
            this.label = label;
            this.align = align;
            this.width = width;
            this.jClass = jClass;
            this.format = format;
        }
    }
}

