/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPoint3D
extends AbstractMultiPoint {
    private static final long serialVersionUID = -2230359991187613190L;

    public MultiPoint3D() {
        super(1);
    }

    public Geometry cloneGeometry() {
        MultiPoint3D clone = new MultiPoint3D();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 3;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new AbstractMultiPoint.PointIterator(null), false, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        return this;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line3D line = new Line3D();
        line.ensureCapacity(this.primitives.size());
        for (Point3D point : this.primitives) {
            line.addVertex(point);
        }
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D();
        polygon.ensureCapacity(this.primitives.size());
        for (Point3D point : this.primitives) {
            polygon.addVertex(point);
        }
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Point3D) {
            return primitive;
        }
        if (primitive instanceof Point) {
            Point point = (Point)primitive;
            if (point instanceof Point3DM) {
                return new Point3D(point.getX(), point.getY(), ((Point3DM)point).getZ());
            }
            return new Point3D(point.getX(), point.getY(), 0.0);
        }
        if (primitive.getGeometryType().getSubType() == 1) {
            try {
                return primitive.toPoints();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to points";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 3D primitives can be fixed to MultiPoint3D";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3D) {
            return point;
        }
        if (point instanceof Point3DM) {
            return new Point3D(point.getX(), point.getY(), ((Point3DM)point).getM());
        }
        return new Point3D(point.getX(), point.getY(), 0.0);
    }
}

