/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPoint3DM
extends AbstractMultiPoint {
    private static final long serialVersionUID = -2230359991187613190L;

    public MultiPoint3DM() {
        super(3);
    }

    public Geometry cloneGeometry() {
        MultiPoint3DM clone = new MultiPoint3DM();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 4;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new AbstractMultiPoint.PointIterator(this, null), false, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        return this;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        Line3DM line = new Line3DM();
        line.ensureCapacity(this.primitives.size());
        for (Point3DM point : this.primitives) {
            line.addVertex(point);
        }
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3DM multiPolygon = new MultiPolygon3DM();
        Polygon3DM polygon = new Polygon3DM();
        polygon.ensureCapacity(this.primitives.size());
        for (Point3DM point : this.primitives) {
            polygon.addVertex(point);
        }
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Point3DM) {
            return primitive;
        }
        if (primitive instanceof Point) {
            Point point = (Point)primitive;
            if (point instanceof Point3D) {
                return new Point3DM(point.getX(), point.getY(), ((Point3DM)point).getZ(), 0.0);
            }
            return new Point3DM(point.getX(), point.getY(), 0.0, 0.0);
        }
        if (primitive.getGeometryType().getSubType() == 3) {
            try {
                return primitive.toPoints();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to points";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 3DM primitives can be fixed to MultiPoint3DM";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3DM) {
            return point;
        }
        if (point instanceof Point3D) {
            return new Point3DM(point.getX(), point.getY(), ((Point3D)point).getZ(), 0.0);
        }
        return new Point3DM(point.getX(), point.getY(), 0.0, 0.0);
    }
}

