/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.json;

import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.util.IsApplicable;

public class GeometryTypeJsonSerializer
implements JsonManager.JsonSerializer,
IsApplicable {
    public Class getObjectClass() {
        return GeometryType.class;
    }

    public Object toObject(JsonObject json) {
        try {
            int type = json.getInt("type");
            int subtype = json.getInt("subtype");
            return GeometryLocator.getGeometryManager().getGeometryType(type, subtype);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't retrieve a GeometryType from JsonObject.", ex);
        }
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        GeometryType geomType = (GeometryType)value;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class(GeometryType.class);
        this.addAll(builder, value);
        return builder;
    }

    private void addAll(JsonObjectBuilder target, Object source) {
        GeometryType geomType = (GeometryType)source;
        target.add("type", geomType.getType());
        target.add("subtype", geomType.getSubType());
    }

    public boolean isApplicable(Object ... args) {
        if (args[0] instanceof GeometryType) {
            return true;
        }
        if (!(args[0] instanceof JsonObject)) {
            return false;
        }
        JsonObject json = (JsonObject)args[0];
        String className = json.getString("__classname__", null);
        return StringUtils.equalsIgnoreCase((CharSequence)className, (CharSequence)GeometryType.class.getName());
    }
}

