/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.mgeom;

import com.vividsolutions.jts.geom.Coordinate;

public class MCoordinate
extends Coordinate {
    private static final long serialVersionUID = 1L;
    public double m;

    public MCoordinate() {
        this.m = Double.NaN;
    }

    public MCoordinate(double x, double y, double z, double m) {
        super(x, y, z);
        this.m = m;
    }

    public MCoordinate(double x, double y) {
        super(x, y);
        this.m = Double.NaN;
    }

    public MCoordinate(Coordinate coord) {
        super(coord);
        this.m = coord instanceof MCoordinate ? ((MCoordinate)coord).m : Double.NaN;
    }

    public MCoordinate(MCoordinate coord) {
        super((Coordinate)coord);
        this.m = coord.m;
    }

    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.m;
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.m = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinateIndex");
            }
        }
    }

    public boolean equals2DWithMeasure(Coordinate other) {
        boolean result = this.equals2D(other);
        if (result) {
            MCoordinate mc = MCoordinate.convertCoordinate(other);
            result = Double.compare(this.m, mc.m) == 0;
        }
        return result;
    }

    public boolean equals3DWithMeasure(Coordinate other) {
        boolean result = this.equals3D(other);
        if (result) {
            MCoordinate mc = MCoordinate.convertCoordinate(other);
            result = Double.compare(this.m, mc.m) == 0;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Coordinate) {
            return this.equals2D((Coordinate)other);
        }
        return false;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + " m=" + this.m + ")";
    }

    public static MCoordinate convertCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        if (coordinate instanceof MCoordinate) {
            return (MCoordinate)coordinate;
        }
        return new MCoordinate(coordinate);
    }

    public static MCoordinate create2dWithMeasure(double x, double y, double m) {
        return new MCoordinate(x, y, Double.NaN, m);
    }

    public static MCoordinate create2d(double x, double y) {
        return new MCoordinate(x, y, Double.NaN, Double.NaN);
    }

    public static MCoordinate create3dWithMeasure(double x, double y, double z, double m) {
        return new MCoordinate(x, y, z, m);
    }

    public static MCoordinate create3d(double x, double y, double z) {
        return new MCoordinate(x, y, z, Double.NaN);
    }
}

