/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.jts.primitive.DefaultEnvelope;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.EnvelopeNotInitializedException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;

public class Envelope3D
extends DefaultEnvelope
implements Cloneable {
    public static final String PERSISTENCE_DEFINITION_NAME = "Envelope3Dimensions";
    private static final int DIMENSION = 3;
    private boolean isZInitilized = false;

    public Envelope3D() {
    }

    public Envelope3D(IProjection projection) {
        super(projection);
    }

    public Envelope3D(Point min, Point max, IProjection projection) {
        super(min, max, projection);
    }

    public Envelope3D(Coordinate[] coordinates) {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double minz = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        double maxz = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < coordinates.length; ++i) {
            double x = coordinates[i].x;
            double y = coordinates[i].x;
            double z = coordinates[i].x;
            minx = Math.min(x, minx);
            miny = Math.min(y, miny);
            minz = Math.min(z, minz);
            maxx = Math.max(x, maxx);
            maxy = Math.max(y, maxy);
            maxz = Math.max(z, maxz);
        }
        if (minx <= maxx && miny <= maxy && minz <= maxz) {
            this.min = new Point3D(minx, miny, minz);
            this.max = new Point3D(maxx, maxy, maxz);
            this.isEmpty = false;
        } else {
            this.isEmpty = true;
        }
    }

    public int getDimension() {
        return 3;
    }

    public Envelope convert(ICoordTrans trans) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        if (trans == null) {
            return new Envelope3D(this.getLowerCorner(), this.getUpperCorner(), this.projection);
        }
        double xmin = this.getMinimum(0);
        double ymin = this.getMinimum(1);
        double step_w = 0.25 * (this.getMaximum(0) - xmin);
        double step_h = 0.25 * (this.getMaximum(1) - ymin);
        Point2D.Double sample = null;
        Point2D sample_trans = null;
        Point2D.Double res_min = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        Point2D.Double res_max = new Point2D.Double(-1.7976931348623157E308, -1.7976931348623157E308);
        int added = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                sample = new Point2D.Double(xmin + (double)i * step_w, ymin + (double)j * step_h);
                sample_trans = new Point2D.Double(0.0, 0.0);
                try {
                    sample_trans = trans.convert((Point2D)sample, sample_trans);
                }
                catch (Exception exc) {
                    continue;
                }
                if (sample_trans.getX() > ((Point2D)res_max).getX()) {
                    ((Point2D)res_max).setLocation(sample_trans.getX(), ((Point2D)res_max).getY());
                }
                if (sample_trans.getX() < ((Point2D)res_min).getX()) {
                    ((Point2D)res_min).setLocation(sample_trans.getX(), ((Point2D)res_min).getY());
                }
                if (sample_trans.getY() > ((Point2D)res_max).getY()) {
                    ((Point2D)res_max).setLocation(((Point2D)res_max).getX(), sample_trans.getY());
                }
                if (sample_trans.getY() < ((Point2D)res_min).getY()) {
                    ((Point2D)res_min).setLocation(((Point2D)res_min).getX(), sample_trans.getY());
                }
                ++added;
            }
        }
        if (added == 0) {
            return null;
        }
        return new Envelope3D(new Point3D(((Point2D)res_min).getX(), ((Point2D)res_min).getY(), this.min.getCoordinateAt(2)), new Point3D(((Point2D)res_max).getX(), ((Point2D)res_max).getY(), this.max.getCoordinateAt(2)), trans.getPDest());
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(Envelope3D.class, PERSISTENCE_DEFINITION_NAME, "Envelope3D persistence definition", null, null);
            definition.extend(manager.getDefinition("Envelope"));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void createPoints() {
        this.min = new Point3D(0.0, 0.0, 0.0);
        this.max = new Point3D(0.0, 0.0, 0.0);
    }

    public void add(Envelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            return;
        }
        int maxDimension = 3;
        if (envelope.getDimension() == 2) {
            maxDimension = 2;
        }
        if (this.isZInitilized) {
            for (int i = 0; i < maxDimension; ++i) {
                this.min.setCoordinateAt(i, Math.min(this.min.getCoordinateAt(i), envelope.getMinimum(i)));
                this.max.setCoordinateAt(i, Math.max(this.max.getCoordinateAt(i), envelope.getMaximum(i)));
            }
            return;
        }
        if (this.isEmpty) {
            this.createPoints();
            if (maxDimension == 3) {
                this.isZInitilized = true;
            }
            for (int i = 0; i < maxDimension; ++i) {
                this.min.setCoordinateAt(i, envelope.getMinimum(i));
                this.max.setCoordinateAt(i, envelope.getMaximum(i));
            }
            this.isEmpty = false;
        } else {
            if (maxDimension == 3) {
                this.min.setCoordinateAt(2, envelope.getMinimum(2));
                this.max.setCoordinateAt(2, envelope.getMaximum(2));
                this.isZInitilized = true;
            }
            for (int i = 0; i < maxDimension; ++i) {
                this.min.setCoordinateAt(i, Math.min(this.min.getCoordinateAt(i), envelope.getMinimum(i)));
                this.max.setCoordinateAt(i, Math.max(this.max.getCoordinateAt(i), envelope.getMaximum(i)));
            }
        }
    }

    @Override
    public boolean hasZ() {
        return true;
    }
}

