/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.arc;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.cresques.cts.CoordTransRuntimeException;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.curve.AbstractCurve;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.Arc2D;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.Arc2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.Arc2DZ;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.Arc2DZM;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.util.UtilFunctions;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class AbstractArc
extends AbstractCurve
implements Arc {
    private static final long serialVersionUID = 454301669807892457L;
    protected Point init;
    protected Point middle;
    protected Point end;

    protected AbstractArc(int subtype) {
        super(12, subtype);
    }

    public void setPoints(Point initialPoint, Point endPoint) {
        String message = "Calling deprecated method setPoints of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public double getCoordinateAt(int index, int dimension) {
        String message = "Calling deprecated method getCoordinateAt of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        String message = "Calling deprecated method setCoordinateAt of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(Point point) {
        String message = "Calling deprecated method addVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y) {
        String message = "Calling deprecated method addVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Calling deprecated method addVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeVertex(int index) {
        String message = "Calling deprecated method removeVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Point getVertex(int index) {
        String message = "Calling deprecated method getVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public int getNumVertices() {
        String message = "Calling deprecated method getNumVertices of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        String message = "Calling deprecated method insertVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        String message = "Calling deprecated method setVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        String message = "Calling deprecated method setGeneralPath of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addMoveToVertex(Point point) {
        String message = "Calling deprecated method addMoveToVertex of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void closePrimitive() {
        String message = "Calling deprecated method closePrimitive of a arc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        return this;
    }

    public void reProject(ICoordTrans ct) {
        try {
            this.init.reProject(ct);
            this.middle.reProject(ct);
            this.end.reProject(ct);
            this.setProjection(ct.getPDest());
        }
        catch (CoordTransRuntimeException e) {
            this.init.setX(0.0);
            this.init.setY(0.0);
            this.middle.setX(0.0);
            this.middle.setY(0.0);
            this.end.setX(0.0);
            this.end.setY(0.0);
        }
    }

    public void transform(AffineTransform at) {
        this.init.transform(at);
        this.middle.transform(at);
        this.end.transform(at);
    }

    public int getDimension() {
        return this.init.getDimension();
    }

    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    @Override
    public boolean is3D() {
        return ((PointJTS)this.init).is3D();
    }

    protected abstract Point fixPoint(Point var1);

    public void setPoints(Point startPoint, Point midPoint, Point endPoint) {
        this.init = this.fixPoint(startPoint);
        this.middle = this.fixPoint(midPoint);
        this.end = this.fixPoint(endPoint);
    }

    public Point getInitPoint() {
        return this.init;
    }

    public Point getEndPoint() {
        return this.end;
    }

    public Point getMiddlePoint() {
        return this.middle;
    }

    protected double normalizeAngle(double angle) {
        return Math.IEEEremainder(angle, Math.PI * 2);
    }

    public void setPointsStartExt(Point center, double radius, double startAngle, double angleExt) {
        this.setPoints(center, radius, startAngle, angleExt);
    }

    public void setPointsStartEnd(Point center, double radius, double startAngle, double endAngle) {
        if (startAngle == endAngle) {
            this.setPointsStartExt(center, radius, startAngle, 0.0);
        } else {
            double ang_ext;
            double norm_start = this.normalizeAngle(startAngle);
            double norm_end = this.normalizeAngle(endAngle);
            if (norm_end < 0.0) {
                norm_end = Math.PI * 2 + norm_end;
            }
            if (norm_start < 0.0) {
                norm_start = Math.PI * 2 + norm_start;
            }
            if ((ang_ext = norm_end - norm_start) < 0.0) {
                ang_ext = Math.PI * 2 + ang_ext;
            }
            this.setPointsStartExt(center, radius, startAngle, ang_ext);
        }
    }

    public GeneralPathX getGeneralPath() {
        DefaultGeneralPathX gp = new DefaultGeneralPathX(this.getPathIterator(null, this.getManager().getFlatness()), this.is3D(), 0.0);
        return gp;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, this.getManager().getFlatness());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        Point2D.Double p3;
        Point2D.Double p2;
        Point2D.Double p1 = new Point2D.Double(this.init.getX(), this.init.getY());
        java.awt.geom.Arc2D arco = UtilFunctions.createArc(p1, p2 = new Point2D.Double(this.middle.getX(), this.middle.getY()), p3 = new Point2D.Double(this.end.getX(), this.end.getY()));
        if (arco == null) {
            LOGGER.info("Did not set arc points (probably aligned points): " + p1.getX() + " " + p1.getY() + " :: " + p2.getX() + " " + p2.getY() + " :: " + p3.getX() + " " + p3.getY());
            throw new IllegalArgumentException("Did not set arc points (probably aligned points).");
        }
        return arco.getPathIterator(at, flatness);
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point aux = this.init;
        this.init = this.end;
        this.end = aux;
    }

    public double getStartAngle() {
        return GeometryUtils.calculateAngle((Point)this.getCenterPoint(), (Point)this.getInitPoint());
    }

    public double getEndAngle() {
        return GeometryUtils.calculateAngle((Point)this.getCenterPoint(), (Point)this.getEndPoint());
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point center = this.getCenterPoint();
        double radius = center.distance((Geometry)this.init);
        double scale = (radius + distance) / radius;
        AffineTransform at = this.getScaleAffineTransform(center, scale);
        Geometry cloned = this.cloneGeometry();
        cloned.transform(at);
        return cloned;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    protected AffineTransform getScaleAffineTransform(Point center, Double scale) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(-center.getX(), -center.getY());
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scale, scale);
        AffineTransform inverseTranslate = AffineTransform.getTranslateInstance(center.getX(), center.getY());
        AffineTransform at = new AffineTransform(translate);
        at.preConcatenate(scaleTransform);
        at.preConcatenate(inverseTranslate);
        return at;
    }

    public boolean canBeTransformed(AffineTransform at) {
        return false;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return false;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Arc2D other = new Arc2D();
        other.setProjection(this.getProjection());
        Point clonedInit = this.init.force2D();
        Point clonedMiddle = this.middle.force2D();
        Point clonedEnd = this.end.force2D();
        other.setPoints(clonedInit, clonedMiddle, clonedEnd);
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Arc2DM other = new Arc2DM();
        other.setProjection(this.getProjection());
        Point clonedInit = this.init.force2DM();
        Point clonedMiddle = this.middle.force2DM();
        Point clonedEnd = this.end.force2DM();
        other.setPoints(clonedInit, clonedMiddle, clonedEnd);
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Arc2DZ other = new Arc2DZ();
        other.setProjection(this.getProjection());
        Point clonedInit = this.init.force3D();
        Point clonedMiddle = this.middle.force3D();
        Point clonedEnd = this.end.force3D();
        other.setPoints(clonedInit, clonedMiddle, clonedEnd);
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Arc2DZM other = new Arc2DZM();
        other.setProjection(this.getProjection());
        Point clonedInit = this.init.force3DM();
        Point clonedMiddle = this.middle.force3DM();
        Point clonedEnd = this.end.force3DM();
        other.setPoints(clonedInit, clonedMiddle, clonedEnd);
        return other;
    }

    @Override
    public boolean isEmpty() {
        return this.init == null || this.end == null || this.middle == null;
    }
}

