/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.AbstractCurve;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLine
extends AbstractCurve
implements Size,
GetItem<Point> {
    private static final long serialVersionUID = 5034197096871344597L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractLine.class);
    protected ArrayListCoordinateSequence coordinates;

    protected AbstractLine(int subtype) {
        super(18, subtype);
    }

    public AbstractLine(int type, int subtype) {
        super(type, subtype);
    }

    public abstract Point getVertex(int var1);

    public Iterator<Point> iterator() {
        return new VertexIterator();
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSLineString(this.getProjection(), this.coordinates);
    }

    public OrientablePrimitive addVertex(Point point) {
        point = this.fixPoint(point);
        this.coordinates.add(((PointJTS)point).getJTSCoordinate());
        return this;
    }

    public void setPoints(Point initialPoint, Point endPoint) {
        initialPoint = this.fixPoint(initialPoint);
        endPoint = this.fixPoint(endPoint);
        this.coordinates.clear();
        this.addVertex(initialPoint);
        this.addVertex(endPoint);
    }

    protected abstract Point fixPoint(Point var1);

    public double getCoordinateAt(int index, int dimension) {
        return this.coordinates.getOrdinate(index, dimension);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        this.coordinates.setOrdinate(index, dimension, value);
        return this;
    }

    public void removeVertex(int index) {
        this.coordinates.remove(index);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates == null || this.coordinates.isEmpty();
    }

    public int getNumVertices() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.coordinates.size();
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        p = this.fixPoint(p);
        this.coordinates.add(index, ((PointJTS)p).getJTSCoordinate());
        return this;
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        p = this.fixPoint(p);
        this.coordinates.set(index, ((PointJTS)p).getJTSCoordinate());
        return this;
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        PathIterator it = generalPathX.getPathIterator(null);
        double[] segment = new double[6];
        int i = 0;
        while (!it.isDone()) {
            Point2D p;
            int type = it.currentSegment(segment);
            if (i == 0) {
                switch (type) {
                    case 0: {
                        p = new Point2D(segment[0], segment[1]);
                        p = this.fixPoint(p);
                        this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        break;
                    }
                    default: {
                        String message = StringUtils.replace((String)"Type of segment %(segment)s isn't SEG_MOVETO.", (String)"%(segment)s", (String)String.valueOf(i));
                        LOGGER.warn(message);
                        throw new RuntimeException(message);
                    }
                }
            } else {
                switch (type) {
                    case 1: {
                        p = new Point2D(segment[0], segment[1]);
                        p = this.fixPoint(p);
                        this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        break;
                    }
                    case 2: {
                        int j;
                        for (j = 0; j <= 1; ++j) {
                            p = new Point2D(segment[i], segment[i + 1]);
                            p = this.fixPoint(p);
                            this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        }
                        break;
                    }
                    case 3: {
                        int j;
                        for (j = 0; j <= 2; ++j) {
                            p = new Point2D(segment[i], segment[i + 1]);
                            p = this.fixPoint(p);
                            this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        }
                        break;
                    }
                    case 4: {
                        if (((Coordinate)this.coordinates.get(0)).equals(this.coordinates.get(this.coordinates.size() - 1))) break;
                        this.coordinates.add(this.coordinates.get(0));
                        break;
                    }
                    default: {
                        String message = StringUtils.replace((String)"The general path has a gap in segment %(segment)s.", (String)"%(segment)s", (String)String.valueOf(i));
                        LOGGER.warn(message);
                        throw new RuntimeException(message);
                    }
                }
            }
            it.next();
            ++i;
        }
    }

    public void addMoveToVertex(Point point) {
        this.notifyDeprecated("Calling deprecated metohd addMoveToVertex in Line");
        throw new UnsupportedOperationException();
    }

    public void closePrimitive() {
        if (!this.isEmpty() && !this.isClosed()) {
            this.coordinates.add((Coordinate)((Coordinate)this.coordinates.get(0)).clone());
        }
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        this.coordinates.ensureCapacity(capacity);
        return this;
    }

    public void reProject(ICoordTrans ct) {
        if (ct == null) {
            return;
        }
        ArrayListCoordinateSequence tmpCoordinates = new ArrayListCoordinateSequence();
        tmpCoordinates.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            java.awt.geom.Point2D p = new Point2D.Double(coordinate.x, coordinate.y);
            try {
                p = ct.convert(p, p);
                coordinate.x = p.getX();
                coordinate.y = p.getY();
                tmpCoordinates.add(coordinate);
            }
            catch (Exception exception) {}
        }
        this.coordinates = tmpCoordinates;
        this.setProjection(ct.getPDest());
    }

    public void transform(AffineTransform at) {
        if (at == null) {
            return;
        }
        for (int i = 0; i < this.coordinates.size(); ++i) {
            Coordinate coordinate = (Coordinate)this.coordinates.get(i);
            Point2D.Double p = new Point2D.Double(coordinate.x, coordinate.y);
            at.transform(p, p);
            coordinate.x = ((java.awt.geom.Point2D)p).getX();
            coordinate.y = ((java.awt.geom.Point2D)p).getY();
        }
    }

    public int getDimension() {
        return this.getGeometryType().getDimension();
    }

    public Shape getShape(AffineTransform affineTransform) {
        if (this.isEmpty()) {
            return new GeneralPath();
        }
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        LineIterator pi = new LineIterator(at);
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public GeneralPathX getGeneralPath() {
        return (GeneralPathX)this.getShape(null);
    }

    @Override
    public boolean is3D() {
        int subtype = this.getGeometryType().getType();
        return subtype == 1 || subtype == 3;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isEmpty()) {
            return;
        }
        Collections.reverse(this.coordinates);
    }

    protected ArrayListCoordinateSequence cloneCoordinates() {
        ArrayListCoordinateSequence cloned = new ArrayListCoordinateSequence();
        cloned.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            cloned.add((Coordinate)coordinate.clone());
        }
        return cloned;
    }

    public boolean canBeTransformed(AffineTransform at) {
        return true;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return true;
    }

    public boolean isClosed() {
        return this.isClosed(0.0);
    }

    public boolean isClosed(double tolerance) {
        int numVertices = this.getNumVertices();
        switch (numVertices) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        if (tolerance < 0.0) {
            tolerance = 1.0E-6;
        }
        double[] first = this.getVertex(0).getCoordinates();
        double[] last = this.getVertex(numVertices - 1).getCoordinates();
        for (int i = 0; i < first.length; ++i) {
            if (!(Math.abs(first[i] - last[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public void forceClose(double tolerance) {
        int numVertices = this.getNumVertices();
        switch (numVertices) {
            case 0: {
                return;
            }
            case 1: {
                Point first = this.getVertex(0);
                this.addVertex(first.cloneGeometry());
                this.addVertex(first.cloneGeometry());
                return;
            }
            case 2: {
                Point first = this.getVertex(0);
                this.addVertex(first.cloneGeometry());
                return;
            }
        }
        if (this.isClosed(0.0)) {
            return;
        }
        Point first = this.getVertex(0);
        if (this.isClosed(tolerance)) {
            this.setVertex(numVertices - 1, first.cloneGeometry());
        } else {
            this.addVertex(first.cloneGeometry());
        }
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Line2D l = new Line2D(coordinates2D);
        return l;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this instanceof Line2DM) {
            return this;
        }
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, coordinate instanceof MCoordinate ? coordinate.getOrdinate(3) : 0.0));
        }
        Line2DM line = new Line2DM(coordinates2DM);
        line.setProjection(this.getProjection());
        return line;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z));
        }
        Line3D line = new Line3D(coordinates3D);
        line.setProjection(this.getProjection());
        return line;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z, coordinate instanceof MCoordinate ? coordinate.getOrdinate(3) : 0.0));
        }
        Line3DM line = new Line3DM(coordinates3DM);
        line.setProjection(this.getProjection());
        return line;
    }

    @Override
    public int size() {
        return this.getNumVertices();
    }

    @Override
    public Point get(int position) {
        return this.getVertex(position);
    }

    public double getPathLength(Point point) {
        return JTSUtils.getPathLengthFromLine(this, point);
    }

    public Point extractPoint(double length) {
        return JTSUtils.extractPointFromLine(this, length);
    }

    protected class LineIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;
        private int index;

        public LineIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            this.done = AbstractLine.this.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            this.done = AbstractLine.this.coordinates.size() == ++this.index;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = AbstractLine.this.coordinates.getX(this.index);
            coords[1] = AbstractLine.this.coordinates.getY(this.index);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)AbstractLine.this.coordinates.getX(this.index);
            coords[1] = (float)AbstractLine.this.coordinates.getY(this.index);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }
    }

    public class VertexIterator
    implements Iterator<Point> {
        private final PointJTS vertex;
        private int current = 0;

        public VertexIterator() {
            this.vertex = AbstractLine.this.getNumVertices() > 0 ? (PointJTS)AbstractLine.this.getVertex(0).cloneGeometry() : null;
        }

        @Override
        public boolean hasNext() {
            return this.current < AbstractLine.this.getNumVertices();
        }

        @Override
        public Point next() {
            this.vertex.setJTSCoordinate((Coordinate)AbstractLine.this.coordinates.get(this.current));
            ++this.current;
            return this.vertex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

