/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;

public class Line3DM
extends BaseLine3DM
implements Line {
    private static final long serialVersionUID = 3467349699229302515L;

    public Line3DM() {
        super(18);
    }

    public Line3DM(Coordinate[] coordinates) {
        super(18, coordinates);
    }

    public Line3DM(ArrayListCoordinateSequence coordinates) {
        super(18, coordinates);
    }

    public Line cloneGeometry() {
        Line3DM clone = new Line3DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Line clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), this.coordinates, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed(0.0)) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, joinStyle, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), this.coordinates, joinStyle, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Line3DM) {
            Line3DM other = (Line3DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) != coordinate.getOrdinate(2)) {
                    return false;
                }
                if (otherCoordinate.getOrdinate(3) == coordinate.getOrdinate(3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Line c = this.cloneGeometry();
        return c;
    }
}

