/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.BaseSpline3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Spline;

public class Spline3DM
extends BaseSpline3DM
implements Spline {
    private static final long serialVersionUID = 6068987767873860480L;

    public Spline3DM() {
        super(14);
    }

    public Spline3DM(Coordinate[] coordinates) {
        super(14, coordinates);
    }

    public Spline3DM(ArrayListCoordinateSequence coordinates) {
        super(14, coordinates);
    }

    public Geometry cloneGeometry() {
        Spline3DM clone = new Spline3DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        for (int i = 0; i < coords.length; ++i) {
            listCoordSequence.add(coords[i]);
        }
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), listCoordSequence, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        for (int i = 0; i < coords.length; ++i) {
            listCoordSequence.add(coords[i]);
        }
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, joinStyle, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), listCoordSequence, joinStyle, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Spline3DM) {
            Spline3DM other = (Spline3DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) != coordinate.getOrdinate(2)) {
                    return false;
                }
                if (otherCoordinate.getOrdinate(3) == coordinate.getOrdinate(3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry c = this.cloneGeometry();
        return c;
    }
}

