/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.AbstractCircle;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseCircle2DZ
extends AbstractCircle {
    private static final long serialVersionUID = -804346064183036328L;

    public BaseCircle2DZ(int type, int subtype, Point center, double radius) {
        super(type, subtype, center, radius);
    }

    public BaseCircle2DZ(int type, int subtype) {
        super(type, subtype);
    }

    public void setPoints(Point p1, Point p2, Point p3) {
        this.center = new Point3D(p1.getProjection(), JTSUtils.getCircumcentre(p1, p2, p3));
        Point3D aPoint = new Point3D(p1.getX(), p1.getY(), ((Point3D)this.center).getZ());
        this.radius = ((PointJTS)this.center).getJTS().distance(aPoint.getJTS());
        this.setProjection(this.center.getProjection());
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3D) {
            return point;
        }
        return new Point3D(point.getX(), point.getY(), 0.0);
    }

    protected ArrayListCoordinateSequence getJTSCoordinates() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        Point3D c = (Point3D)this.getCenter();
        double zValue = c.getZ();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new Coordinate(coords[0], coords[1], zValue));
                    break;
                }
                case 1: {
                    coordinates.add(new Coordinate(coords[0], coords[1], zValue));
                    break;
                }
                case 2: {
                    coordinates.add(new Coordinate(coords[0], coords[1], zValue));
                    coordinates.add(new Coordinate(coords[2], coords[3], zValue));
                    break;
                }
                case 3: {
                    coordinates.add(new Coordinate(coords[0], coords[1], zValue));
                    coordinates.add(new Coordinate(coords[2], coords[3], zValue));
                    coordinates.add(new Coordinate(coords[4], coords[5], zValue));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        if (!((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates.add((Coordinate)((Coordinate)coordinates.get(0)).clone());
        }
        return coordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point3D(this.getProjection(), coordinates[i]));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line3D line = new Line3D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

