/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.AbstractCircle;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseCircle2DZM
extends AbstractCircle {
    public BaseCircle2DZM(int type, int subtype, Point center, double radius) {
        super(type, subtype, center, radius);
    }

    public BaseCircle2DZM(int type, int subtype) {
        super(type, subtype);
    }

    public void setPoints(Point p1, Point p2, Point p3) {
        this.center = new Point3DM(p1.getProjection(), JTSUtils.getCircumcentre(p1, p2, p3));
        Point3DM aPoint = new Point3DM(p1.getX(), p1.getY(), ((Point3DM)this.center).getZ(), ((Point3DM)this.center).getM());
        this.radius = ((PointJTS)this.center).getJTS().distance(aPoint.getJTS());
        this.setProjection(this.center.getProjection());
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3DM) {
            return point;
        }
        if (point instanceof Point3D) {
            return new Point3DM(point.getX(), point.getY(), ((Point3D)point).getZ(), 0.0);
        }
        if (point instanceof Point2DM) {
            return new Point3DM(point.getX(), point.getY(), 0.0, ((Point2DM)point).getM());
        }
        return new Point3DM(point.getX(), point.getY(), 0.0, 0.0);
    }

    protected ArrayListCoordinateSequence getJTSCoordinates() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        Point3DM c = (Point3DM)this.getCenter();
        double zValue = c.getZ();
        double mValue = c.getM();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], zValue, mValue));
                    break;
                }
                case 1: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], zValue, mValue));
                    break;
                }
                case 2: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], zValue, mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], zValue, mValue));
                    break;
                }
                case 3: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], zValue, mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], zValue, mValue));
                    coordinates.add(new MCoordinate(coords[4], coords[5], zValue, mValue));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        if (!((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates.add((Coordinate)((Coordinate)coordinates.get(0)).clone());
        }
        return coordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3DM multiPoint = new MultiPoint3DM();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point3DM(this.getProjection(), coordinates[i]));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        Line3DM line = new Line3DM(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3DM multiPolygon = new MultiPolygon3DM();
        Polygon3DM polygon = new Polygon3DM(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

