/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.ellipse;

import java.awt.geom.AffineTransform;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.BaseEllipse2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Point;

public class Ellipse2D
extends BaseEllipse2D
implements Ellipse {
    private static final long serialVersionUID = 3414562338763885954L;

    public Ellipse2D() {
        super(13);
    }

    public Geometry cloneGeometry() {
        Ellipse2D clone = new Ellipse2D();
        clone.setPoints(this.init.cloneGeometry(), this.end.cloneGeometry(), this.ydist);
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayListCoordinateSequence coordinates = this.getJTSCoordinates();
        return JTSUtils.createJTSPolygon(this.getProjection(), coordinates);
    }

    public Point getRectangleCorner() {
        return new Point2D(this.getAxis1Start().getX(), this.getAxis1Start().getY() - this.getAxis2Dist());
    }

    public double getRectangleHeight() {
        return this.getAxis2Dist() * 2.0;
    }

    public double getRectangleWidth() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.getAxis1Start().distance((Geometry)this.getAxis1End());
    }

    public AffineTransform getRectangleRotation() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return AffineTransform.getRotateInstance(this.getAxis1Angle(), this.getAxis1Start().getX(), this.getAxis1Start().getY());
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Ellipse clonedEllipse = (Ellipse)this.cloneGeometry();
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point2D center = new Point2D((this.getAxis1Start().getX() + this.getAxis1End().getX()) / 2.0, (this.getAxis1Start().getY() + this.getAxis1End().getY()) / 2.0);
        double axis1Lenght = this.getAxis1Start().distance((Geometry)this.getAxis1End());
        Point clonedAxis1Start = this.getAxis1Start().cloneGeometry();
        Point clonedAxis1End = this.getAxis1End().cloneGeometry();
        double clonedYDist = this.ydist + distance;
        clonedAxis1Start.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1Start().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1Start.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1Start().getY(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1End().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1End().getY(), axis1Lenght / 2.0 + distance));
        clonedEllipse.setPoints(clonedAxis1Start, clonedAxis1End, clonedYDist);
        return clonedEllipse;
    }
}

