/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.spatialindex;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.spi.spatialindex.AbstractSpatialIndex;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.Visitor;

public class SpatialIndexJSIRTree
extends AbstractSpatialIndex
implements SpatialIndex {
    private RTree index = null;

    public SpatialIndexJSIRTree(GeometryManager geometryManager, SpatialIndexFactory factory, DynObject parameters) {
        super(geometryManager, factory, parameters);
        this.open();
    }

    public void open() {
        this.index = new RTree();
        Properties props = new Properties();
        if (this.getParameter("MaxNodeEntries") != null) {
            props.setProperty("MaxNodeEntries", ((Integer)this.getParameter("MaxNodeEntries")).toString());
        }
        if (this.getParameter("MinNodeEntries") != null) {
            props.setProperty("MinNodeEntries", ((Integer)this.getParameter("MinNodeEntries")).toString());
        }
        this.index.init(props);
    }

    public void close() {
        this.index = null;
    }

    private Rectangle asJSI(Envelope envelope) {
        Point min = envelope.getLowerCorner();
        Point max = envelope.getUpperCorner();
        Rectangle rectangle = new Rectangle((float)min.getX(), (float)min.getY(), (float)max.getX(), (float)max.getY());
        return rectangle;
    }

    public long size() {
        return this.index.size();
    }

    public void query(Envelope envelope, final Visitor visitor) {
        this.index.intersects(this.asJSI(envelope), new IntProcedure(){

            public boolean execute(int i) {
                try {
                    visitor.visit((Object)i);
                }
                catch (BaseException ex) {
                    return false;
                }
                return true;
            }
        });
    }

    public Iterator query(Envelope envelope, final long limit) {
        final ArrayList results = new ArrayList();
        this.index.intersects(this.asJSI(envelope), new IntProcedure(){

            public boolean execute(int i) {
                results.add(i);
                return (long)results.size() < limit;
            }
        });
        return results.iterator();
    }

    public Iterator queryNearest(Envelope envelope, long limit) {
        Collection results = this.index.nearest(this.asJSI(envelope), (int)limit);
        return results.iterator();
    }

    public Iterator queryAll() {
        return this.index.iterator();
    }

    public void insert(Envelope envelope, Object data) {
        Integer number = (Integer)this.coerceData(data);
        if (number == null) {
            throw new IllegalArgumentException("null data are not allowed.");
        }
        this.index.add(this.asJSI(envelope), number.intValue());
    }

    public boolean remove(Envelope envelope, Object data) {
        Integer number = (Integer)this.coerceData(data);
        if (number == null) {
            throw new IllegalArgumentException("null data are not allowed.");
        }
        return this.index.delete(this.asJSI(envelope), number.intValue());
    }

    public void removeAll() {
        this.close();
        this.open();
    }

    class Values
    implements IntProcedure {
        List elements = new ArrayList();

        Values() {
        }

        public boolean execute(int arg0) {
            this.elements.add(arg0);
            return true;
        }

        public List getElements() {
            return this.elements;
        }
    }
}

